/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.web.file;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.View;

public class StaticAssetView
implements View {
    private static final Log LOG = LogFactory.getLog(StaticAssetView.class);
    protected boolean browserAssetCachingEnabled = true;

    public String getContentType() {
        return null;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String cacheFilePath = (String)model.get("cacheFilePath");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(cacheFilePath));
        try {
            String mimeType = (String)model.get("mimeType");
            response.setContentType(mimeType);
            if (!this.browserAssetCachingEnabled) {
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
            }
            ServletOutputStream os = response.getOutputStream();
            boolean eof = false;
            while (!eof) {
                int temp = bis.read();
                if (temp < 0) {
                    eof = true;
                    continue;
                }
                os.write(temp);
            }
            os.flush();
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to stream asset", (Throwable)e);
            throw e;
        }
        finally {
            try {
                bis.close();
            }
            catch (Throwable e) {}
        }
    }

    public boolean isBrowserAssetCachingEnabled() {
        return this.browserAssetCachingEnabled;
    }

    public void setBrowserAssetCachingEnabled(boolean browserAssetCachingEnabled) {
        this.browserAssetCachingEnabled = browserAssetCachingEnabled;
    }
}

