/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.web;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.page.domain.Page;
import org.broadleafcommerce.cms.page.service.PageService;
import org.broadleafcommerce.cms.web.BroadleafRequestContext;
import org.broadleafcommerce.cms.web.URLProcessor;
import org.springframework.stereotype.Component;

@Component(value="blPageURLProcessor")
public class PageURLProcessor
implements URLProcessor {
    private static final Log LOG = LogFactory.getLog(PageURLProcessor.class);
    @Resource(name="blPageService")
    private PageService pageService;
    private String blcPageTemplateDirectory = "/WEB-INF/jsp/templates";
    private static final String PAGE_ATTRIBUTE_NAME = "BLC_PAGE";

    @Override
    public boolean canProcessURL(String key) {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        Page p = this.pageService.findPageByURI(context.getSandbox(), context.getLocale(), key);
        context.getRequest().setAttribute(PAGE_ATTRIBUTE_NAME, (Object)p);
        return p != null;
    }

    @Override
    public void processURL(String key) throws IOException, ServletException {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        Page p = (Page)context.getRequest().getAttribute(PAGE_ATTRIBUTE_NAME);
        if (p == null) {
            p = this.pageService.findPageByURI(context.getSandbox(), context.getLocale(), key);
        }
        if (p != null) {
            String templateJSPPath = this.blcPageTemplateDirectory + p.getPageTemplate().getTemplatePath() + ".jsp";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Forwarding to page: " + templateJSPPath));
            }
            context.getRequest().setAttribute(PAGE_ATTRIBUTE_NAME, (Object)p);
            RequestDispatcher rd = context.getRequest().getRequestDispatcher(templateJSPPath);
            rd.forward((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
        }
    }

    public String getBlcPageTemplateDirectory() {
        return this.blcPageTemplateDirectory;
    }

    public void setBlcPageTemplateDirectory(String blcPageTemplateDirectory) {
        this.blcPageTemplateDirectory = blcPageTemplateDirectory;
    }
}

