/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.web;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.web.BroadleafRequestContext;
import org.broadleafcommerce.cms.web.NullURLProcessor;
import org.broadleafcommerce.cms.web.URLProcessor;
import org.broadleafcommerce.common.RequestDTOImpl;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.broadleafcommerce.openadmin.server.domain.Site;
import org.broadleafcommerce.openadmin.server.service.persistence.SandBoxService;
import org.broadleafcommerce.openadmin.time.FixedTimeSource;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.broadleafcommerce.openadmin.time.TimeSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="blProcessURLFilter")
public class BroadleafProcessURLFilter
extends OncePerRequestFilter {
    private final Log LOG = LogFactory.getLog(BroadleafProcessURLFilter.class);
    private List<URLProcessor> urlProcessorList = new ArrayList<URLProcessor>();
    private int cacheExpirationSeconds = 14400;
    private int maxCacheElements = 10000;
    private int maxCacheConcurrency = 3;
    private Cache<String, URLProcessor> urlCache;
    @Resource(name="blSandBoxService")
    private SandBoxService sandBoxService;
    @Resource(name="blLocaleService")
    private LocaleService localeService;
    protected Boolean sandBoxPreviewEnabled = true;
    public static String LOCALE_VAR = "blLocale";
    public static String LOCALE_CODE_PARAM = "blLocaleCode";
    public static String REQUEST_DTO = "blRequestDTO";
    public static String SANDBOX_VAR = "blSandbox";
    private static final String BLC_ADMIN = "org.broadleafcommerce.admin";
    private static final String BLC_ADMIN_SERVICE = ".service";
    private HashSet<String> ignoreSuffixes;
    private static String SANDBOX_ID_VAR = "blSandboxId";
    private static String SANDBOX_DATE_TIME_VAR = "blSandboxDateTime";
    private static final SimpleDateFormat CONTENT_DATE_FORMATTER = new SimpleDateFormat("yyyyMMddHHmm");
    private static final SimpleDateFormat CONTENT_DATE_DISPLAY_FORMATTER = new SimpleDateFormat("MM/dd/yyyy");
    private static final SimpleDateFormat CONTENT_DATE_DISPLAY_HOURS_FORMATTER = new SimpleDateFormat("h");
    private static final SimpleDateFormat CONTENT_DATE_DISPLAY_MINUTES_FORMATTER = new SimpleDateFormat("mm");
    private static final SimpleDateFormat CONTENT_DATE_PARSE_FORMAT = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
    private static String SANDBOX_DATE_TIME_RIBBON_OVERRIDE_PARAM = "blSandboxDateTimeRibbonOverride";
    private static final String SANDBOX_DISPLAY_DATE_TIME_DATE_PARAM = "blSandboxDisplayDateTimeDate";
    private static final String SANDBOX_DISPLAY_DATE_TIME_HOURS_PARAM = "blSandboxDisplayDateTimeHours";
    private static final String SANDBOX_DISPLAY_DATE_TIME_MINUTES_PARAM = "blSandboxDisplayDateTimeMinutes";
    private static final String SANDBOX_DISPLAY_DATE_TIME_AMPM_PARAM = "blSandboxDisplayDateTimeAMPM";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!this.shouldProcessURL(request, request.getRequestURI())) {
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Process URL not processing URL " + request.getRequestURI()));
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requestURIWithoutContext = request.getContextPath() != null ? request.getRequestURI().substring(request.getContextPath().length()) : request.getRequestURI();
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Process URL Filter Begin " + requestURIWithoutContext));
        }
        if (request.getAttribute(REQUEST_DTO) == null) {
            request.setAttribute(REQUEST_DTO, (Object)new RequestDTOImpl(request));
        }
        Site site = this.determineSite((ServletRequest)request);
        SandBox currentSandbox = this.determineSandbox(request, site);
        BroadleafRequestContext brc = new BroadleafRequestContext();
        brc.setLocale(this.determineLocale(request, site));
        brc.setSandbox(currentSandbox);
        brc.setRequest(request);
        brc.setResponse(response);
        BroadleafRequestContext.setBroadleafRequestContext(brc);
        try {
            URLProcessor urlProcessor = null;
            if (this.isProduction(currentSandbox)) {
                try {
                    urlProcessor = this.lookupProcessorFromCache(requestURIWithoutContext);
                }
                catch (ExecutionException e) {
                    this.LOG.error((Object)e);
                }
            }
            if (urlProcessor == null) {
                urlProcessor = this.determineURLProcessor(requestURIWithoutContext);
            }
            if (urlProcessor instanceof NullURLProcessor) {
                if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace((Object)("URL not being processed by a Broadleaf URLProcessor " + requestURIWithoutContext));
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace((Object)("URL about to be processed by a Broadleaf URLProcessor " + requestURIWithoutContext));
                }
                urlProcessor.processURL(requestURIWithoutContext);
            }
        }
        finally {
            SystemTime.resetLocalTimeSource();
        }
    }

    private boolean isProduction(SandBox sandbox) {
        return sandbox == null || SandBoxType.PRODUCTION.equals((Object)sandbox);
    }

    private URLProcessor lookupProcessorFromCache(String requestURIWithoutContextPath) throws ExecutionException {
        if (this.urlCache == null) {
            this.urlCache = CacheBuilder.newBuilder().maximumSize(this.maxCacheElements).concurrencyLevel(this.maxCacheConcurrency).expireAfterWrite((long)this.cacheExpirationSeconds, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, URLProcessor>(){

                public URLProcessor load(String key) throws IOException, ServletException {
                    if (BroadleafProcessURLFilter.this.LOG.isDebugEnabled()) {
                        BroadleafProcessURLFilter.this.LOG.debug((Object)"Loading URL processor into Cache");
                    }
                    return BroadleafProcessURLFilter.this.determineURLProcessor(key);
                }
            });
        }
        return (URLProcessor)this.urlCache.get((Object)requestURIWithoutContextPath);
    }

    private URLProcessor determineURLProcessor(String requestURI) {
        for (URLProcessor processor : this.getUrlProcessorList()) {
            if (!processor.canProcessURL(requestURI)) continue;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("URLProcessor found for URI " + requestURI + " - " + processor.getClass().getName()));
            }
            return processor;
        }
        return NullURLProcessor.getInstance();
    }

    protected boolean shouldProcessURL(HttpServletRequest request, String requestURI) {
        if (requestURI.contains(BLC_ADMIN) || requestURI.endsWith(BLC_ADMIN_SERVICE)) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("BroadleafProcessURLFilter ignoring admin request URI " + requestURI));
            }
            return false;
        }
        int pos = requestURI.lastIndexOf(".");
        if (pos > 0) {
            String suffix = requestURI.substring(pos);
            if (this.getIgnoreSuffixes().contains(suffix.toLowerCase())) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("BroadleafProcessURLFilter ignoring request due to suffix " + requestURI));
                }
                return false;
            }
        }
        return true;
    }

    private SandBox determineSandbox(HttpServletRequest request, Site site) {
        SandBox currentSandbox = null;
        if (!this.sandBoxPreviewEnabled.booleanValue()) {
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)"Sandbox preview disabled. Setting sandbox to production");
            }
            request.setAttribute(SANDBOX_VAR, currentSandbox);
        } else {
            Long sandboxId = null;
            if (request.getParameter("blSandboxDateTimeRibbonProduction") == null) {
                sandboxId = this.lookupSandboxId(request);
            } else {
                request.getSession().removeAttribute(SANDBOX_DATE_TIME_VAR);
                request.getSession().removeAttribute(SANDBOX_ID_VAR);
            }
            if (sandboxId != null) {
                currentSandbox = this.sandBoxService.retrieveSandboxById(sandboxId);
                request.setAttribute(SANDBOX_VAR, (Object)currentSandbox);
                if (currentSandbox != null && !SandBoxType.PRODUCTION.equals((Object)currentSandbox.getSandBoxType())) {
                    this.setContentTime(request);
                }
            }
            if (currentSandbox == null && site != null) {
                currentSandbox = site.getProductionSandbox();
            }
        }
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Serving request using sandbox: " + currentSandbox));
        }
        Date currentSystemDateTime = SystemTime.asDate((boolean)true);
        Calendar sandboxDateTimeCalendar = Calendar.getInstance();
        sandboxDateTimeCalendar.setTime(currentSystemDateTime);
        request.setAttribute(SANDBOX_DISPLAY_DATE_TIME_DATE_PARAM, (Object)CONTENT_DATE_DISPLAY_FORMATTER.format(currentSystemDateTime));
        request.setAttribute(SANDBOX_DISPLAY_DATE_TIME_HOURS_PARAM, (Object)CONTENT_DATE_DISPLAY_HOURS_FORMATTER.format(currentSystemDateTime));
        request.setAttribute(SANDBOX_DISPLAY_DATE_TIME_MINUTES_PARAM, (Object)CONTENT_DATE_DISPLAY_MINUTES_FORMATTER.format(currentSystemDateTime));
        request.setAttribute(SANDBOX_DISPLAY_DATE_TIME_AMPM_PARAM, (Object)sandboxDateTimeCalendar.get(9));
        return currentSandbox;
    }

    private Locale determineLocale(HttpServletRequest request, Site site) {
        Locale locale = null;
        locale = (Locale)request.getAttribute(LOCALE_VAR);
        if (locale == null && request.getParameter(LOCALE_CODE_PARAM) != null) {
            String localeCode = request.getParameter(LOCALE_CODE_PARAM);
            locale = this.localeService.findLocaleByCode(localeCode);
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Attempt to find locale by param " + localeCode + " resulted in " + locale));
            }
        }
        if (locale == null) {
            HttpSession session = request.getSession(true);
            if (session != null) {
                locale = (Locale)session.getAttribute(LOCALE_VAR);
            }
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Attempt to find locale from session resulted in " + locale));
            }
        }
        if (locale == null) {
            locale = this.localeService.findDefaultLocale();
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Locale set to default locale " + locale));
            }
        }
        request.setAttribute(LOCALE_VAR, (Object)locale);
        request.getSession().setAttribute(LOCALE_VAR, (Object)locale);
        HashMap<String, Locale> ruleMap = (HashMap<String, Locale>)request.getAttribute("blRuleMap");
        if (ruleMap == null) {
            ruleMap = new HashMap<String, Locale>();
            request.setAttribute("blRuleMap", ruleMap);
        }
        ruleMap.put("locale", locale);
        return locale;
    }

    private Long lookupSandboxId(HttpServletRequest request) {
        String sandboxIdStr = request.getParameter(SANDBOX_ID_VAR);
        Long sandboxId = null;
        if (sandboxIdStr != null) {
            try {
                sandboxId = Long.valueOf(sandboxIdStr);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("SandboxId found on request " + sandboxId));
                }
            }
            catch (NumberFormatException nfe) {
                this.LOG.debug((Object)"blcSandboxId parameter could not be converted into a Long", (Throwable)nfe);
            }
        }
        if (sandboxId == null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                sandboxId = (Long)session.getAttribute(SANDBOX_ID_VAR);
                if (this.LOG.isDebugEnabled() && sandboxId != null) {
                    this.LOG.debug((Object)("SandboxId found in session " + sandboxId));
                }
            }
        } else {
            HttpSession session = request.getSession();
            session.setAttribute(SANDBOX_ID_VAR, (Object)sandboxId);
        }
        return sandboxId;
    }

    private void setContentTime(HttpServletRequest request) {
        HttpSession session;
        String sandboxDateTimeParam = request.getParameter(SANDBOX_DATE_TIME_VAR);
        if (this.sandBoxPreviewEnabled.booleanValue()) {
            sandboxDateTimeParam = null;
        }
        Date overrideTime = null;
        try {
            if (request.getParameter(SANDBOX_DATE_TIME_RIBBON_OVERRIDE_PARAM) != null) {
                overrideTime = this.readDateFromRequest(request);
            } else if (sandboxDateTimeParam != null) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Setting date/time using " + sandboxDateTimeParam));
                }
                overrideTime = CONTENT_DATE_FORMATTER.parse(sandboxDateTimeParam);
            }
        }
        catch (ParseException e) {
            this.LOG.debug((Object)e);
        }
        if (overrideTime == null) {
            session = request.getSession(false);
            if (session != null) {
                overrideTime = (Date)session.getAttribute(SANDBOX_DATE_TIME_VAR);
            }
        } else {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Setting date-time for sandbox mode to " + overrideTime + " for sandboxDateTimeParam = " + sandboxDateTimeParam));
            }
            session = request.getSession();
            session.setAttribute(SANDBOX_DATE_TIME_VAR, (Object)overrideTime);
        }
        if (overrideTime != null) {
            FixedTimeSource ft = new FixedTimeSource(overrideTime.getTime());
            SystemTime.setLocalTimeSource((TimeSource)ft);
        } else {
            SystemTime.resetLocalTimeSource();
        }
    }

    private Date readDateFromRequest(HttpServletRequest request) throws ParseException {
        String date = request.getParameter(SANDBOX_DISPLAY_DATE_TIME_DATE_PARAM);
        String minutes = request.getParameter(SANDBOX_DISPLAY_DATE_TIME_MINUTES_PARAM);
        String hours = request.getParameter(SANDBOX_DISPLAY_DATE_TIME_HOURS_PARAM);
        String ampm = request.getParameter(SANDBOX_DISPLAY_DATE_TIME_AMPM_PARAM);
        if (StringUtils.isEmpty((String)minutes)) {
            minutes = Integer.toString(SystemTime.asCalendar().get(12));
        }
        if (StringUtils.isEmpty((String)hours)) {
            hours = Integer.toString(SystemTime.asCalendar().get(11));
        }
        String dateString = date + " " + hours + ":" + minutes + " " + ampm;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Setting date/time using " + dateString));
        }
        Date parsedDate = CONTENT_DATE_PARSE_FORMAT.parse(dateString);
        return parsedDate;
    }

    private Site determineSite(ServletRequest request) {
        return null;
    }

    protected Set getIgnoreSuffixes() {
        if (this.ignoreSuffixes == null || this.ignoreSuffixes.isEmpty()) {
            String[] ignoreSuffixList = new String[]{".aif", ".aiff", ".asf", ".avi", ".bin", ".bmp", ".doc", ".eps", ".gif", ".hqx", ".jpg", ".jpeg", ".mid", ".midi", ".mov", ".mp3", ".mpg", ".mpeg", ".p65", ".pdf", ".pic", ".pict", ".png", ".ppt", ".psd", ".qxd", ".ram", ".ra", ".rm", ".sea", ".sit", ".stk", ".swf", ".tif", ".tiff", ".txt", ".rtf", ".vob", ".wav", ".wmf", ".xls", ".zip"};
            this.ignoreSuffixes = new HashSet<String>(Arrays.asList(ignoreSuffixList));
        }
        return this.ignoreSuffixes;
    }

    public int getMaxCacheElements() {
        return this.maxCacheElements;
    }

    public void setMaxCacheElements(int maxCacheElements) {
        this.maxCacheElements = maxCacheElements;
    }

    public int getCacheExpirationSeconds() {
        return this.cacheExpirationSeconds;
    }

    public void setCacheExpirationSeconds(int cacheExpirationSeconds) {
        this.cacheExpirationSeconds = cacheExpirationSeconds;
    }

    public int getMaxCacheConcurrency() {
        return this.maxCacheConcurrency;
    }

    public void setMaxCacheConcurrency(int maxCacheConcurrency) {
        this.maxCacheConcurrency = maxCacheConcurrency;
    }

    public List<URLProcessor> getUrlProcessorList() {
        return this.urlProcessorList;
    }

    public void setUrlProcessorList(List<URLProcessor> urlProcessorList) {
        this.urlProcessorList = urlProcessorList;
    }

    public Boolean getSandBoxPreviewEnabled() {
        return this.sandBoxPreviewEnabled;
    }

    public void setSandBoxPreviewEnabled(Boolean sandBoxPreviewEnabled) {
        this.sandBoxPreviewEnabled = sandBoxPreviewEnabled;
    }
}

