/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.cms.structure.domain.StructuredContentFieldTemplate;
import org.broadleafcommerce.cms.structure.domain.StructuredContentFieldTemplateImpl;
import org.broadleafcommerce.cms.structure.domain.StructuredContentType;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.presentation.AdminPresentationClass;
import org.broadleafcommerce.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.presentation.RequiredOverride;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SC_TYPE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCMSElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseStructuredContentType")
public class StructuredContentTypeImpl
implements StructuredContentType {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="StructuredContentTypeId", strategy=GenerationType.TABLE)
    @TableGenerator(name="StructuredContentTypeId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="StructuredContentTypeImpl", allocationSize=10)
    @Column(name="SC_TYPE_ID")
    protected Long id;
    @Column(name="NAME")
    @AdminPresentation(friendlyName="Name", order=1, group="Details", prominent=true)
    protected String name;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="Description", order=2, group="Details", prominent=true)
    protected String description;
    @ManyToOne(targetEntity=StructuredContentFieldTemplateImpl.class)
    @JoinColumn(name="SC_FLD_TMPLT_ID")
    @AdminPresentation(friendlyName="Content Template", order=2, group="Details", requiredOverride=RequiredOverride.REQUIRED, visibility=VisibilityEnum.HIDDEN_ALL)
    protected StructuredContentFieldTemplate structuredContentFieldTemplate;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public StructuredContentFieldTemplate getStructuredContentFieldTemplate() {
        return this.structuredContentFieldTemplate;
    }

    @Override
    public void setStructuredContentFieldTemplate(StructuredContentFieldTemplate scft) {
        this.structuredContentFieldTemplate = scft;
    }
}

