/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.cms.structure.dao.StructuredContentDao;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentField;
import org.broadleafcommerce.cms.structure.domain.StructuredContentType;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxImpl;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blStructuredContentDao")
public class StructuredContentDaoImpl
implements StructuredContentDao {
    private static SandBox DUMMY_SANDBOX = new SandBoxImpl();
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    public StructuredContentDaoImpl() {
        DUMMY_SANDBOX.setId(Long.valueOf(-1L));
    }

    @Override
    public StructuredContent findStructuredContentById(Long contentId) {
        return (StructuredContent)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.cms.structure.domain.StructuredContent"), (Object)contentId);
    }

    @Override
    public StructuredContentType findStructuredContentTypeById(Long contentTypeId) {
        return (StructuredContentType)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.cms.structure.domain.StructuredContentType"), (Object)contentTypeId);
    }

    @Override
    public List<StructuredContentType> retrieveAllStructuredContentTypes() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_STRUCTURED_CONTENT_TYPES");
        return query.getResultList();
    }

    @Override
    public Map<String, StructuredContentField> readFieldsForStructuredContentItem(StructuredContent sc) {
        Query query = this.em.createNamedQuery("BC_READ_CONTENT_FIELDS_BY_CONTENT_ID");
        query.setParameter("structuredContent", (Object)sc);
        List fields = query.getResultList();
        HashMap<String, StructuredContentField> fieldMap = new HashMap<String, StructuredContentField>();
        for (StructuredContentField scField : fields) {
            fieldMap.put(scField.getFieldKey(), scField);
        }
        return fieldMap;
    }

    @Override
    public StructuredContent addOrUpdateContentItem(StructuredContent content) {
        return (StructuredContent)this.em.merge((Object)content);
    }

    @Override
    public void delete(StructuredContent content) {
        if (!this.em.contains((Object)content)) {
            content = this.findStructuredContentById(content.getId());
        }
        this.em.remove((Object)content);
    }

    @Override
    public List<StructuredContent> findActiveStructuredContentByType(SandBox sandBox, StructuredContentType type, Locale locale) {
        String queryName = null;
        queryName = sandBox == null ? "BC_ACTIVE_STRUCTURED_CONTENT_BY_TYPE" : (SandBoxType.PRODUCTION.equals((Object)sandBox) ? "BC_ACTIVE_STRUCTURED_CONTENT_BY_TYPE_AND_PRODUCTION_SANDBOX" : "BC_ACTIVE_STRUCTURED_CONTENT_BY_TYPE_AND_USER_SANDBOX");
        Query query = this.em.createNamedQuery(queryName);
        query.setParameter("contentType", (Object)type);
        query.setParameter("locale", (Object)locale);
        if (sandBox != null) {
            query.setParameter("sandbox", (Object)sandBox);
        }
        return query.getResultList();
    }

    @Override
    public List<StructuredContent> findActiveStructuredContentByNameAndType(SandBox sandBox, StructuredContentType type, String name, Locale locale) {
        String queryName = null;
        queryName = sandBox == null ? "BC_ACTIVE_STRUCTURED_CONTENT_BY_TYPE_AND_NAME" : (SandBoxType.PRODUCTION.equals((Object)sandBox) ? "BC_ACTIVE_STRUCTURED_CONTENT_BY_TYPE_AND_NAME_AND_PRODUCTION_SANDBOX" : "BC_ACTIVE_STRUCTURED_CONTENT_BY_TYPE_AND_NAME_AND_USER_SANDBOX");
        Query query = this.em.createNamedQuery(queryName);
        query.setParameter("contentType", (Object)type);
        query.setParameter("contentName", (Object)name);
        query.setParameter("locale", (Object)locale);
        if (sandBox != null) {
            query.setParameter("sandbox", (Object)sandBox);
        }
        return query.getResultList();
    }

    @Override
    public StructuredContentType findStructuredContentTypeByName(String name) {
        Query query = this.em.createNamedQuery("BC_READ_STRUCTURED_CONTENT_TYPE_BY_NAME");
        query.setParameter("name", (Object)name);
        List results = query.getResultList();
        if (results.size() > 0) {
            return (StructuredContentType)results.get(0);
        }
        return null;
    }

    @Override
    public void detach(StructuredContent sc) {
        this.em.detach((Object)sc);
    }
}

