/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.page.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.page.dao.PageDao;
import org.broadleafcommerce.cms.page.domain.Page;
import org.broadleafcommerce.cms.page.domain.PageField;
import org.broadleafcommerce.cms.page.domain.PageTemplate;
import org.broadleafcommerce.cms.page.service.PageService;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.openadmin.server.dao.SandBoxDao;
import org.broadleafcommerce.openadmin.server.dao.SandBoxItemDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemListener;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxOperationType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Service;

@Service(value="blPageService")
public class PageServiceImpl
implements PageService,
SandBoxItemListener {
    private static final Log LOG = LogFactory.getLog(PageServiceImpl.class);
    @Resource(name="blPageDao")
    protected PageDao pageDao;
    @Resource(name="blSandBoxItemDao")
    protected SandBoxItemDao sandBoxItemDao;
    @Resource(name="blSandBoxDao")
    protected SandBoxDao sandBoxDao;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;

    @Override
    public Page findPageById(Long pageId) {
        return this.pageDao.readPageById(pageId);
    }

    @Override
    public PageTemplate findPageTemplateById(Long id) {
        return this.pageDao.readPageTemplateById(id);
    }

    @Override
    public Map<String, PageField> findPageFieldsByPageId(Long pageId) {
        Page page = this.findPageById(pageId);
        return this.pageDao.readPageFieldsByPage(page);
    }

    @Override
    public Page addPage(Page page, SandBox destinationSandbox) {
        page.setSandbox(destinationSandbox);
        page.setArchivedFlag(false);
        page.setDeletedFlag(false);
        Page newPage = this.pageDao.addPage(page);
        if (!this.isProductionSandBox(destinationSandbox)) {
            this.sandBoxItemDao.addSandBoxItem(destinationSandbox, SandBoxOperationType.ADD, SandBoxItemType.PAGE, newPage.getFullUrl(), newPage.getId(), null);
        }
        return newPage;
    }

    @Override
    public Page updatePage(Page page, SandBox destSandbox) {
        if (page.getLockedFlag().booleanValue()) {
            throw new IllegalArgumentException("Unable to update a locked record");
        }
        if (this.checkForSandboxMatch(page.getSandbox(), destSandbox)) {
            if (page.getDeletedFlag().booleanValue()) {
                SandBoxItem item = this.sandBoxItemDao.retrieveBySandboxAndTemporaryItemId(page.getSandbox(), SandBoxItemType.PAGE, page.getId());
                if (page.getOriginalPageId() == null) {
                    item.setArchivedFlag(Boolean.valueOf(true));
                    page.setArchivedFlag(true);
                } else {
                    item.setSandBoxOperationType(SandBoxOperationType.DELETE);
                    this.sandBoxItemDao.updateSandBoxItem(item);
                }
            }
            return this.pageDao.updatePage(page);
        }
        if (this.isProductionSandBox(page.getSandbox())) {
            Page clonedPage = page.cloneEntity();
            clonedPage.setOriginalPageId(page.getId());
            clonedPage.setSandbox(destSandbox);
            this.pageDao.detachPage(page);
            Page returnPage = this.pageDao.addPage(clonedPage);
            Page prod = this.findPageById(page.getId());
            prod.setLockedFlag(true);
            this.pageDao.updatePage(prod);
            SandBoxOperationType type = SandBoxOperationType.UPDATE;
            if (clonedPage.getDeletedFlag().booleanValue()) {
                type = SandBoxOperationType.DELETE;
            }
            this.sandBoxItemDao.addSandBoxItem(destSandbox, type, SandBoxItemType.PAGE, clonedPage.getFullUrl(), returnPage.getId(), returnPage.getOriginalPageId());
            return returnPage;
        }
        throw new IllegalArgumentException("Update called when promote or reject was expected.");
    }

    private boolean checkForSandboxMatch(SandBox src, SandBox dest) {
        if (src != null && dest != null) {
            return src.getId().equals(dest.getId());
        }
        return src == null && dest == null;
    }

    private boolean isProductionSandBox(SandBox dest) {
        if (dest == null) {
            return true;
        }
        return SandBoxType.PRODUCTION.equals((Object)dest.getSandBoxType());
    }

    @Override
    public void deletePage(Page page, SandBox destinationSandbox) {
        page.setDeletedFlag(true);
        this.updatePage(page, destinationSandbox);
    }

    @Override
    public Page findPageByURI(SandBox currentSandbox, Locale locale, String uri) {
        if (uri != null) {
            Page sandboxPage;
            SandBox productionSandbox = null;
            if (currentSandbox != null && currentSandbox.getSite() != null) {
                productionSandbox = currentSandbox.getSite().getProductionSandbox();
            }
            Page productionPage = this.pageDao.findPageByURI(productionSandbox, locale, uri);
            if (currentSandbox != null && !currentSandbox.getSandBoxType().equals((Object)SandBoxType.PRODUCTION) && (sandboxPage = this.pageDao.findPageByURI(currentSandbox, locale, uri)) != null) {
                if (sandboxPage.getDeletedFlag().booleanValue()) {
                    return null;
                }
                return sandboxPage;
            }
            return productionPage;
        }
        return null;
    }

    @Override
    public Long countPages(SandBox sandbox, Criteria criteria) {
        Criterion productionSandboxExpression;
        criteria.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        criteria.setProjection(Projections.rowCount());
        if (sandbox == null) {
            criteria.add(Restrictions.isNull((String)"sandbox"));
            return (Long)criteria.uniqueResult();
        }
        SimpleExpression originalSandboxExpression = Restrictions.eq((String)"originalSandBox", (Object)sandbox);
        SimpleExpression currentSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox);
        if (sandbox.getSite() == null || sandbox.getSite().getProductionSandbox() == null) {
            productionSandboxExpression = Restrictions.isNull((String)"sandbox");
        } else {
            if (sandbox.getId().equals(sandbox.getSite().getProductionSandbox().getId())) {
                return (Long)criteria.uniqueResult();
            }
            productionSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox.getSite().getProductionSandbox());
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)productionSandboxExpression), (Criterion)originalSandboxExpression));
        Long resultCount = (Long)criteria.list().get(0);
        Long updatedCount = 0L;
        Long deletedCount = 0L;
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"originalPageId"), (Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression)));
        updatedCount = (Long)criteria.list().get(0);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"deletedFlag", (Object)true), (Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression)));
        deletedCount = (Long)criteria.list().get(0);
        return resultCount - updatedCount - deletedCount;
    }

    @Override
    public List<Page> findPages(SandBox sandbox, Criteria criteria) {
        criteria.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        if (sandbox == null) {
            criteria.add(Restrictions.isNull((String)"sandbox"));
            return criteria.list();
        }
        SimpleExpression originalSandboxExpression = Restrictions.eq((String)"originalSandBox", (Object)sandbox);
        SimpleExpression currentSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox);
        Criterion productionSandboxExpression = null;
        if (sandbox.getSite() == null || sandbox.getSite().getProductionSandbox() == null) {
            productionSandboxExpression = Restrictions.isNull((String)"sandbox");
        } else if (!SandBoxType.PRODUCTION.equals((Object)sandbox.getSandBoxType())) {
            productionSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox.getSite().getProductionSandbox());
        }
        if (productionSandboxExpression != null) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)productionSandboxExpression), (Criterion)originalSandboxExpression));
        } else {
            criteria.add((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression));
        }
        List resultList = criteria.list();
        LinkedHashMap<Long, Page> returnItems = new LinkedHashMap<Long, Page>();
        for (Page page : resultList) {
            returnItems.put(page.getId(), page);
        }
        for (Page page : resultList) {
            if (page.getOriginalPageId() != null) {
                returnItems.remove(page.getOriginalPageId());
            }
            if (!page.getDeletedFlag().booleanValue()) continue;
            returnItems.remove(page.getId());
        }
        return new ArrayList<Page>(returnItems.values());
    }

    public void itemPromoted(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.PAGE.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        Page page = this.pageDao.readPageById(sandBoxItem.getTemporaryItemId());
        if (page == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Page not found " + sandBoxItem.getTemporaryItemId()));
            }
        } else {
            boolean productionSandBox = this.isProductionSandBox(destinationSandBox);
            if (productionSandBox) {
                page.setLockedFlag(false);
            } else {
                page.setLockedFlag(true);
            }
            if (productionSandBox && page.getOriginalPageId() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Page promoted to production.  " + page.getId() + ".  Archiving original page " + page.getOriginalPageId()));
                }
                Page originalPage = this.pageDao.readPageById(page.getOriginalPageId());
                originalPage.setArchivedFlag(Boolean.TRUE);
                this.pageDao.updatePage(originalPage);
                page.setOriginalPageId(null);
                if (page.getDeletedFlag().booleanValue()) {
                    page.setArchivedFlag(true);
                }
            }
        }
        if (page.getOriginalSandBox() == null) {
            page.setOriginalSandBox(page.getSandbox());
        }
        page.setSandbox(destinationSandBox);
        this.pageDao.updatePage(page);
    }

    public void itemRejected(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.PAGE.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        Page page = this.pageDao.readPageById(sandBoxItem.getTemporaryItemId());
        if (page != null) {
            page.setSandbox(destinationSandBox);
            page.setOriginalSandBox(null);
            page.setLockedFlag(false);
            this.pageDao.updatePage(page);
        }
    }

    public void itemReverted(SandBoxItem sandBoxItem) {
        if (!SandBoxItemType.PAGE.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        Page page = this.pageDao.readPageById(sandBoxItem.getTemporaryItemId());
        if (page != null) {
            page.setArchivedFlag(Boolean.TRUE);
            page.setLockedFlag(false);
            this.pageDao.updatePage(page);
            if (page.getOriginalPageId() != null) {
                Page originalPage = this.pageDao.readPageById(page.getOriginalPageId());
                originalPage.setLockedFlag(false);
                this.pageDao.updatePage(originalPage);
            }
        }
    }
}

