/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.file.dao.StaticAssetDao;
import org.broadleafcommerce.cms.file.domain.StaticAsset;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.cms.file.service.StaticAssetStorageService;
import org.broadleafcommerce.openadmin.server.dao.SandBoxItemDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxOperationType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Service;

@Service(value="blStaticAssetService")
public class StaticAssetServiceImpl
implements StaticAssetService {
    private static final Log LOG = LogFactory.getLog(StaticAssetServiceImpl.class);
    @Resource(name="blStaticAssetDao")
    protected StaticAssetDao staticAssetDao;
    @Resource(name="blSandBoxItemDao")
    protected SandBoxItemDao sandBoxItemDao;
    @Resource(name="blStaticAssetStorageService")
    protected StaticAssetStorageService staticAssetStorageService;

    @Override
    public StaticAsset findStaticAssetById(Long id) {
        return this.staticAssetDao.readStaticAssetById(id);
    }

    @Override
    public StaticAsset findStaticAssetByFullUrl(String fullUrl, SandBox targetSandBox) {
        return this.staticAssetDao.readStaticAssetByFullUrl(fullUrl, targetSandBox);
    }

    @Override
    public StaticAsset addStaticAsset(StaticAsset staticAsset, SandBox destinationSandbox) {
        staticAsset.setSandbox(destinationSandbox);
        staticAsset.setArchivedFlag(false);
        staticAsset.setDeletedFlag(false);
        StaticAsset newAsset = this.staticAssetDao.addOrUpdateStaticAsset(staticAsset, true);
        if (!this.isProductionSandBox(destinationSandbox)) {
            this.sandBoxItemDao.addSandBoxItem(destinationSandbox, SandBoxOperationType.ADD, SandBoxItemType.STATIC_ASSET, newAsset.getFullUrl(), newAsset.getId(), null);
        }
        return newAsset;
    }

    @Override
    public StaticAsset updateStaticAsset(StaticAsset staticAsset, SandBox destSandbox) {
        if (staticAsset.getLockedFlag().booleanValue()) {
            throw new IllegalArgumentException("Unable to update a locked record");
        }
        if (this.checkForSandboxMatch(staticAsset.getSandbox(), destSandbox)) {
            if (staticAsset.getDeletedFlag().booleanValue()) {
                SandBoxItem item = this.sandBoxItemDao.retrieveBySandboxAndTemporaryItemId(staticAsset.getSandbox(), SandBoxItemType.STATIC_ASSET, staticAsset.getId());
                if (staticAsset.getOriginalAssetId() == null) {
                    staticAsset.setArchivedFlag(true);
                    item.setArchivedFlag(Boolean.valueOf(true));
                } else {
                    item.setSandBoxOperationType(SandBoxOperationType.DELETE);
                    this.sandBoxItemDao.updateSandBoxItem(item);
                }
            }
            return this.staticAssetDao.addOrUpdateStaticAsset(staticAsset, true);
        }
        if (this.isProductionSandBox(staticAsset.getSandbox())) {
            StaticAsset clonedAsset = staticAsset.cloneEntity();
            clonedAsset.setOriginalAssetId(staticAsset.getId());
            clonedAsset.setSandbox(destSandbox);
            StaticAsset returnAsset = this.staticAssetDao.addOrUpdateStaticAsset(clonedAsset, true);
            StaticAsset prod = this.findStaticAssetById(staticAsset.getId());
            prod.setLockedFlag(true);
            this.staticAssetDao.addOrUpdateStaticAsset(prod, false);
            SandBoxOperationType type = SandBoxOperationType.UPDATE;
            if (clonedAsset.getDeletedFlag().booleanValue()) {
                type = SandBoxOperationType.DELETE;
            }
            this.sandBoxItemDao.addSandBoxItem(destSandbox, type, SandBoxItemType.STATIC_ASSET, returnAsset.getFullUrl(), returnAsset.getId(), returnAsset.getOriginalAssetId());
            return returnAsset;
        }
        throw new IllegalArgumentException("Update called when promote or reject was expected.");
    }

    private boolean checkForSandboxMatch(SandBox src, SandBox dest) {
        if (src != null && dest != null) {
            return src.getId().equals(dest.getId());
        }
        return src == null && dest == null;
    }

    private boolean checkForProductionSandbox(SandBox dest) {
        boolean productionSandbox = false;
        if (dest == null) {
            productionSandbox = true;
        } else if (dest.getSite() != null && dest.getSite().getProductionSandbox() != null && dest.getSite().getProductionSandbox().getId() != null) {
            productionSandbox = dest.getSite().getProductionSandbox().getId().equals(dest.getId());
        }
        return productionSandbox;
    }

    private boolean isProductionSandBox(SandBox dest) {
        if (dest == null) {
            return true;
        }
        return SandBoxType.PRODUCTION.equals((Object)dest.getSandBoxType());
    }

    @Override
    public void deleteStaticAsset(StaticAsset staticAsset, SandBox destinationSandbox) {
        staticAsset.setDeletedFlag(true);
        this.updateStaticAsset(staticAsset, destinationSandbox);
    }

    @Override
    public Long countAssets(SandBox sandbox, Criteria criteria) {
        Criterion productionSandboxExpression;
        criteria.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        criteria.setProjection(Projections.rowCount());
        if (sandbox == null) {
            criteria.add(Restrictions.isNull((String)"sandbox"));
            return (Long)criteria.uniqueResult();
        }
        SimpleExpression originalSandboxExpression = Restrictions.eq((String)"originalSandBox", (Object)sandbox);
        SimpleExpression currentSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox);
        if (sandbox.getSite() == null || sandbox.getSite().getProductionSandbox() == null) {
            productionSandboxExpression = Restrictions.isNull((String)"sandbox");
        } else {
            if (sandbox.getId().equals(sandbox.getSite().getProductionSandbox().getId())) {
                return (Long)criteria.uniqueResult();
            }
            productionSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox.getSite().getProductionSandbox());
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)productionSandboxExpression), (Criterion)originalSandboxExpression));
        Long resultCount = (Long)criteria.list().get(0);
        Long updatedCount = 0L;
        Long deletedCount = 0L;
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"originalAssetId"), (Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression)));
        updatedCount = (Long)criteria.list().get(0);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"deletedFlag", (Object)true), (Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression)));
        deletedCount = (Long)criteria.list().get(0);
        return resultCount - updatedCount - deletedCount;
    }

    @Override
    public List<StaticAsset> findAssets(SandBox sandbox, Criteria criteria) {
        criteria.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        if (sandbox == null) {
            criteria.add(Restrictions.isNull((String)"sandbox"));
            return criteria.list();
        }
        SimpleExpression originalSandboxExpression = Restrictions.eq((String)"originalSandBox", (Object)sandbox);
        SimpleExpression currentSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox);
        Criterion productionSandboxExpression = null;
        if (sandbox.getSite() == null || sandbox.getSite().getProductionSandbox() == null) {
            productionSandboxExpression = Restrictions.isNull((String)"sandbox");
        } else if (!SandBoxType.PRODUCTION.equals((Object)sandbox.getSandBoxType())) {
            productionSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox.getSite().getProductionSandbox());
        }
        if (productionSandboxExpression != null) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)productionSandboxExpression), (Criterion)originalSandboxExpression));
        } else {
            criteria.add((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression));
        }
        List resultList = criteria.list();
        LinkedHashMap<Long, StaticAsset> returnItems = new LinkedHashMap<Long, StaticAsset>();
        for (StaticAsset page : resultList) {
            returnItems.put(page.getId(), page);
        }
        for (StaticAsset asset : resultList) {
            if (asset.getOriginalAssetId() != null) {
                returnItems.remove(asset.getOriginalAssetId());
            }
            if (!asset.getDeletedFlag().booleanValue()) continue;
            returnItems.remove(asset.getId());
        }
        return new ArrayList<StaticAsset>(returnItems.values());
    }

    public void itemPromoted(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STATIC_ASSET.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StaticAsset asset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
        if (asset == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Asset not found " + sandBoxItem.getTemporaryItemId()));
            }
        } else {
            boolean productionSandBox = this.isProductionSandBox(destinationSandBox);
            if (productionSandBox) {
                asset.setLockedFlag(false);
            } else {
                asset.setLockedFlag(true);
            }
            if (productionSandBox && asset.getOriginalAssetId() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Asset promoted to production.  " + asset.getId() + ".  Archiving original asset " + asset.getOriginalAssetId()));
                }
                StaticAsset originalAsset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
                originalAsset.setArchivedFlag(Boolean.TRUE);
                this.staticAssetDao.addOrUpdateStaticAsset(originalAsset, false);
                asset.setOriginalAssetId(null);
                if (asset.getDeletedFlag().booleanValue()) {
                    asset.setArchivedFlag(Boolean.TRUE);
                }
            }
        }
        if (asset.getOriginalSandBox() == null) {
            asset.setOriginalSandBox(asset.getSandbox());
        }
        asset.setSandbox(destinationSandBox);
        this.staticAssetDao.addOrUpdateStaticAsset(asset, false);
    }

    public void itemRejected(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STATIC_ASSET.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StaticAsset asset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
        if (asset != null) {
            asset.setSandbox(destinationSandBox);
            asset.setOriginalSandBox(null);
            asset.setLockedFlag(false);
            this.staticAssetDao.addOrUpdateStaticAsset(asset, false);
        }
    }

    public void itemReverted(SandBoxItem sandBoxItem) {
        if (!SandBoxItemType.STATIC_ASSET.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StaticAsset asset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
        if (asset != null) {
            asset.setArchivedFlag(Boolean.TRUE);
            asset.setLockedFlag(false);
            this.staticAssetDao.addOrUpdateStaticAsset(asset, false);
            StaticAsset originalAsset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getOriginalItemId());
            originalAsset.setLockedFlag(false);
            this.staticAssetDao.addOrUpdateStaticAsset(originalAsset, false);
        }
    }
}

