/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.dao;

import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.broadleafcommerce.cms.file.dao.StaticAssetDao;
import org.broadleafcommerce.cms.file.domain.StaticAsset;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxImpl;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="blStaticAssetDao")
public class StaticAssetDaoImpl
implements StaticAssetDao {
    private static SandBox DUMMY_SANDBOX = new SandBoxImpl();
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    public StaticAssetDaoImpl() {
        DUMMY_SANDBOX.setId(Long.valueOf(-1L));
    }

    @Override
    public StaticAsset readStaticAssetById(Long id) {
        return (StaticAsset)this.em.find(this.entityConfiguration.lookupEntityClass(StaticAsset.class.getName()), (Object)id);
    }

    @Override
    public StaticAsset readStaticAssetByFullUrl(String fullUrl, SandBox targetSandBox) {
        TypedQuery query;
        if (targetSandBox == null) {
            query = this.em.createNamedQuery("BC_READ_STATIC_ASSET_BY_FULL_URL_AND_TARGET_SANDBOX_NULL", StaticAsset.class);
            query.setParameter("fullUrl", (Object)fullUrl);
        } else {
            query = this.em.createNamedQuery("BC_READ_STATIC_ASSET_BY_FULL_URL", StaticAsset.class);
            query.setParameter("targetSandbox", (Object)targetSandBox);
            query.setParameter("fullUrl", (Object)fullUrl);
        }
        List results = query.getResultList();
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return (StaticAsset)results.iterator().next();
    }

    @Override
    public StaticAsset addOrUpdateStaticAsset(StaticAsset asset, boolean clearLevel1Cache) {
        if (clearLevel1Cache) {
            this.em.detach((Object)asset);
        }
        return (StaticAsset)this.em.merge((Object)asset);
    }

    @Override
    public void delete(StaticAsset asset) {
        if (!this.em.contains((Object)asset)) {
            asset = this.readStaticAssetById(asset.getId());
        }
        this.em.remove((Object)asset);
    }
}

