/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.service;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentRule;
import org.broadleafcommerce.cms.structure.service.AbstractStructuredContentRuleProcessor;
import org.springframework.stereotype.Service;

@Service(value="blContentDefaultRuleProcessor")
public class StructuredContentDefaultRuleProcessor
extends AbstractStructuredContentRuleProcessor {
    private static final Log LOG = LogFactory.getLog(StructuredContentDefaultRuleProcessor.class);
    private static String AND = " && ";

    @Override
    public boolean checkForMatch(StructuredContent sc, Map<String, Object> vars) {
        StringBuffer ruleExpression = null;
        Map<String, StructuredContentRule> ruleMap = sc.getStructuredContentMatchRules();
        if (ruleMap != null) {
            for (String ruleKey : ruleMap.keySet()) {
                if (ruleExpression == null) {
                    ruleExpression = new StringBuffer(ruleMap.get(ruleKey).getMatchRule());
                    continue;
                }
                ruleExpression.append(AND);
                ruleExpression.append(ruleMap.get(ruleKey).getMatchRule());
            }
        }
        if (ruleExpression != null) {
            boolean result;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing content rule for StructuredContent with id " + sc.getId() + ".   Value = " + ruleExpression.toString()));
            }
            if (!(result = this.executeExpression(ruleExpression.toString(), vars).booleanValue()) && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Content failed to pass rule and will not be included for StructuredContent with id " + sc.getId() + ".   Value = " + ruleExpression.toString()));
            }
            return result;
        }
        return true;
    }
}

