/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.service;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.file.dao.StaticAssetStorageDao;
import org.broadleafcommerce.cms.file.domain.StaticAsset;
import org.broadleafcommerce.cms.file.domain.StaticAssetStorage;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.cms.file.service.StaticAssetStorageService;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.service.artifact.ArtifactService;
import org.broadleafcommerce.openadmin.server.service.artifact.image.Operation;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="blStaticAssetStorageService")
public class StaticAssetStorageServiceImpl
implements StaticAssetStorageService {
    private static final Log LOG = LogFactory.getLog(StaticAssetStorageServiceImpl.class);
    private static final File DEFAULTCACHEDIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    protected String cacheDirectory;
    protected boolean cleanupThreadEnabled = true;
    private final List<CleanupOperation> operations = new ArrayList<CleanupOperation>(100);
    @Resource(name="blStaticAssetService")
    protected StaticAssetService staticAssetService;
    @Resource(name="blArtifactService")
    protected ArtifactService artifactService;
    @Resource(name="blStaticAssetStorageDao")
    protected StaticAssetStorageDao staticAssetStorageDao;
    protected Thread cleanupThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: while (StaticAssetStorageServiceImpl.this.cleanupThreadEnabled) {
                try {
                    ArrayList myList;
                    List list = StaticAssetStorageServiceImpl.this.operations;
                    synchronized (list) {
                        myList = new ArrayList(StaticAssetStorageServiceImpl.this.operations.size());
                        myList.addAll(StaticAssetStorageServiceImpl.this.operations);
                        StaticAssetStorageServiceImpl.this.operations.clear();
                    }
                    for (final CleanupOperation operation : myList) {
                        File[] obsoleteFiles;
                        if (!StaticAssetStorageServiceImpl.this.cleanupThreadEnabled) break block11;
                        File parentDir = operation.cacheFile.getParentFile();
                        if (parentDir.exists() && (obsoleteFiles = parentDir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File file, String s) {
                                return s.startsWith(operation.assetName + "---") && !operation.getCacheFile().getName().equals(s);
                            }
                        })) != null) {
                            for (File file : obsoleteFiles) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Deleting obsolete asset cache file: " + file.getAbsolutePath()));
                                }
                                try {
                                    if (file.delete()) continue;
                                    LOG.warn((Object)("Unable to cleanup obsolete static file: " + file.getAbsolutePath()));
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (StaticAssetStorageServiceImpl.this.cleanupThreadEnabled) continue;
                        break block11;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Cleanup operation failed", (Throwable)e);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StaticAssetStorageServiceImpl.this.cleanupThreadEnabled) continue;
            }
            LOG.debug((Object)"Exiting CMS Cleanup Thread.");
        }
    }, "CMSStaticAssetCleanupThread");

    public StaticAssetStorageServiceImpl() {
        this.cleanupThread.start();
    }

    @PreDestroy
    public void destroy() {
        this.cleanupThreadEnabled = false;
        try {
            this.cleanupThread.interrupt();
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to shutdown CMS Cleanup Thread", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getCacheFileModel(String fullUrl, SandBox sandBox, Map<String, String> parameterMap) throws Exception {
        String cacheName;
        StaticAsset staticAsset = this.staticAssetService.findStaticAssetByFullUrl(fullUrl, sandBox);
        if (staticAsset == null && sandBox != null) {
            staticAsset = this.staticAssetService.findStaticAssetByFullUrl(fullUrl, null);
        }
        if (staticAsset == null) {
            assert (sandBox != null);
            throw new RuntimeException("Unable to find an asset for the url (" + fullUrl + ") using the sandBox id (" + sandBox.getId() + "), or the production sandBox.");
        }
        String mimeType = staticAsset.getMimeType();
        File cacheFile = new File(this.cacheDirectory != null ? new File(this.cacheDirectory) : DEFAULTCACHEDIRECTORY, cacheName = this.constructCacheFileName(staticAsset, parameterMap));
        if (!cacheFile.exists()) {
            this.clearObsoleteCacheFiles(staticAsset, cacheFile);
            StaticAssetStorage storage = this.readStaticAssetStorageByStaticAssetId(staticAsset.getId());
            if (!parameterMap.isEmpty()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = null;
                try {
                    is = storage.getFileData().getBinaryStream();
                    boolean eof = false;
                    while (!eof) {
                        int temp = is.read();
                        if (temp < 0) {
                            eof = true;
                            continue;
                        }
                        baos.write(temp);
                    }
                    baos.flush();
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable e) {}
                    }
                }
                ByteArrayInputStream original = new ByteArrayInputStream(baos.toByteArray());
                Operation[] operations = this.artifactService.buildOperations(parameterMap, (InputStream)original, staticAsset.getMimeType());
                InputStream converted = this.artifactService.convert((InputStream)original, operations, staticAsset.getMimeType());
                this.createCacheFile(converted, cacheFile);
                if ("image/gif".equals(mimeType)) {
                    mimeType = "image/png";
                }
            } else {
                this.createCacheFile(storage.getFileData().getBinaryStream(), cacheFile);
            }
        }
        HashMap<String, String> model = new HashMap<String, String>(2);
        model.put("cacheFilePath", cacheFile.getAbsolutePath());
        model.put("mimeType", mimeType);
        return model;
    }

    @Override
    public StaticAssetStorage findStaticAssetStorageById(Long id) {
        return this.staticAssetStorageDao.readStaticAssetStorageById(id);
    }

    @Override
    public StaticAssetStorage create() {
        return this.staticAssetStorageDao.create();
    }

    @Override
    public StaticAssetStorage readStaticAssetStorageByStaticAssetId(Long id) {
        return this.staticAssetStorageDao.readStaticAssetStorageByStaticAssetId(id);
    }

    @Override
    public StaticAssetStorage save(StaticAssetStorage assetStorage) {
        return this.staticAssetStorageDao.save(assetStorage);
    }

    @Override
    public void delete(StaticAssetStorage assetStorage) {
        this.staticAssetStorageDao.delete(assetStorage);
    }

    @Override
    public Blob createBlob(MultipartFile uploadedFile) throws IOException {
        return this.staticAssetStorageDao.createBlob(uploadedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearObsoleteCacheFiles(StaticAsset staticAsset, File cacheFile) {
        File parentDir = cacheFile.getParentFile();
        if (parentDir.exists()) {
            CleanupOperation operation = new CleanupOperation();
            operation.setAssetName(staticAsset.getName());
            operation.setCacheFile(cacheFile);
            List<CleanupOperation> list = this.operations;
            synchronized (list) {
                this.operations.add(operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCacheFile(InputStream is, File cacheFile) throws SQLException, IOException {
        if (!cacheFile.getParentFile().exists() && !cacheFile.getParentFile().mkdirs()) {
            throw new RuntimeException("Unable to create middle directories for file: " + cacheFile.getAbsolutePath());
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cacheFile));
        try {
            boolean eof = false;
            while (!eof) {
                int temp = is.read();
                if (temp < 0) {
                    eof = true;
                    continue;
                }
                bos.write(temp);
            }
        }
        finally {
            try {
                bos.flush();
                bos.close();
            }
            catch (Throwable e) {}
        }
    }

    protected String constructCacheFileName(StaticAsset staticAsset, Map<String, String> parameterMap) {
        String digest;
        StringBuilder sb = new StringBuilder(200);
        sb.append(staticAsset.getFullUrl().substring(0, staticAsset.getFullUrl().lastIndexOf(46)));
        sb.append("---");
        StringBuilder sb2 = new StringBuilder(200);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        sb2.append(format.format(staticAsset.getAuditable().getDateUpdated() == null ? staticAsset.getAuditable().getDateCreated() : staticAsset.getAuditable().getDateUpdated()));
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            sb2.append('-');
            sb2.append(entry.getKey());
            sb2.append('-');
            sb2.append(entry.getValue());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(sb2.toString().getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            digest = number.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        sb.append(this.pad(digest, 32, '0'));
        sb.append('.');
        sb.append(staticAsset.getFileExtension());
        return sb.toString();
    }

    protected String pad(String s, int length, char pad) {
        StringBuilder buffer = new StringBuilder(s);
        while (buffer.length() < length) {
            buffer.insert(0, pad);
        }
        return buffer.toString();
    }

    public String getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public boolean isCleanupThreadEnabled() {
        return this.cleanupThreadEnabled;
    }

    public void setCleanupThreadEnabled(boolean cleanupThreadEnabled) {
        this.cleanupThreadEnabled = cleanupThreadEnabled;
    }

    public static class CleanupOperation {
        private String assetName;
        private File cacheFile;

        public String getAssetName() {
            return this.assetName;
        }

        public void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        public File getCacheFile() {
            return this.cacheFile;
        }

        public void setCacheFile(File cacheFile) {
            this.cacheFile = cacheFile;
        }
    }
}

