/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.server.handler;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.structure.domain.StructuredContentItemCriteria;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;

public class StructuredContentItemCriteriaCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private Log LOG = LogFactory.getLog(StructuredContentItemCriteriaCustomPersistenceHandler.class);

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        return StructuredContentItemCriteria.class.getName().equals(ceilingEntityFullyQualifiedClassname);
    }

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        return this.canHandleAdd(persistencePackage);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleAdd(persistencePackage);
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            StructuredContentItemCriteria adminInstance = (StructuredContentItemCriteria)Class.forName(entity.getType()[0]).newInstance();
            Map adminProperties = helper.getSimpleMergedProperties(StructuredContentItemCriteria.class.getName(), persistencePerspective);
            adminInstance = (StructuredContentItemCriteria)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            if (adminInstance.getStructuredContent().getLockedFlag().booleanValue()) {
                throw new IllegalArgumentException("Unable to update a locked record");
            }
            adminInstance = (StructuredContentItemCriteria)dynamicEntityDao.merge((Serializable)adminInstance);
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            return adminEntity;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public Entity update(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(StructuredContentItemCriteria.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            StructuredContentItemCriteria adminInstance = (StructuredContentItemCriteria)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            adminInstance = (StructuredContentItemCriteria)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            if (adminInstance.getStructuredContent().getLockedFlag().booleanValue()) {
                throw new IllegalArgumentException("Unable to update a locked record");
            }
            adminInstance = (StructuredContentItemCriteria)dynamicEntityDao.merge((Serializable)adminInstance);
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            return adminEntity;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to update entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public void remove(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(StructuredContentItemCriteria.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            StructuredContentItemCriteria adminInstance = (StructuredContentItemCriteria)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            if (adminInstance.getStructuredContent().getLockedFlag().booleanValue()) {
                throw new IllegalArgumentException("Unable to update a locked record");
            }
            dynamicEntityDao.remove((Serializable)adminInstance);
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to remove entity for " + entity.getType()[0], (Throwable)e);
        }
    }
}

