/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.server.handler;

import com.anasoft.os.daofusion.criteria.PersistentEntityCriteria;
import com.anasoft.os.daofusion.cto.client.CriteriaTransferObject;
import com.anasoft.os.daofusion.cto.client.FilterAndSortCriteria;
import com.anasoft.os.daofusion.cto.server.CriteriaTransferObjectCountWrapper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.file.domain.StaticAssetImpl;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentImpl;
import org.broadleafcommerce.cms.structure.domain.StructuredContentRule;
import org.broadleafcommerce.cms.structure.domain.StructuredContentType;
import org.broadleafcommerce.cms.structure.domain.StructuredContentTypeImpl;
import org.broadleafcommerce.cms.structure.service.StructuredContentService;
import org.broadleafcommerce.cms.structure.service.type.StructuredContentRuleType;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.openadmin.client.dto.ClassMetadata;
import org.broadleafcommerce.openadmin.client.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.FieldMetadata;
import org.broadleafcommerce.openadmin.client.dto.FieldPresentationAttributes;
import org.broadleafcommerce.openadmin.client.dto.ForeignKey;
import org.broadleafcommerce.openadmin.client.dto.MergedPropertyType;
import org.broadleafcommerce.openadmin.client.dto.OperationType;
import org.broadleafcommerce.openadmin.client.dto.OperationTypes;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.dto.Property;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.openadmin.client.presentation.SupportedFieldType;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.cto.BaseCtoConverter;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.service.SandBoxContext;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.PersistenceManager;
import org.broadleafcommerce.openadmin.server.service.persistence.SandBoxService;
import org.broadleafcommerce.openadmin.server.service.persistence.module.InspectHelper;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.hibernate.Criteria;
import org.hibernate.tool.hbm2x.StringUtils;

public class StructuredContentCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private Log LOG = LogFactory.getLog(StructuredContentCustomPersistenceHandler.class);
    private static Map<String, FieldMetadata> mergedProperties;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blStructuredContentService")
    protected StructuredContentService structuredContentService;
    @Resource(name="blSandBoxService")
    protected SandBoxService sandBoxService;

    public Boolean canHandleInspect(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        return StructuredContent.class.getName().equals(ceilingEntityFullyQualifiedClassname);
    }

    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    protected SandBox getSandBox() {
        return this.sandBoxService.retrieveSandboxById(SandBoxContext.getSandBoxContext().getSandBoxId());
    }

    protected synchronized Map<String, FieldMetadata> getModifiedProperties() {
        return mergedProperties;
    }

    protected synchronized void createModifiedProperties(DynamicEntityDao dynamicEntityDao, InspectHelper helper, PersistencePerspective persistencePerspective) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, ServiceException, NoSuchFieldException {
        mergedProperties = helper.getSimpleMergedProperties(StructuredContent.class.getName(), persistencePerspective);
        FieldMetadata fieldMetadata = new FieldMetadata();
        fieldMetadata.setFieldType(SupportedFieldType.EXPLICIT_ENUMERATION);
        fieldMetadata.setMutable(Boolean.valueOf(true));
        fieldMetadata.setInheritedFromType(StructuredContentImpl.class.getName());
        fieldMetadata.setAvailableToTypes(new String[]{StructuredContentImpl.class.getName()});
        fieldMetadata.setCollection(Boolean.valueOf(false));
        fieldMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        PersistencePackage fetchPackage = new PersistencePackage();
        fetchPackage.setCeilingEntityFullyQualifiedClassname(Locale.class.getName());
        PersistencePerspective fetchPerspective = new PersistencePerspective();
        fetchPackage.setPersistencePerspective(fetchPerspective);
        fetchPerspective.setAdditionalForeignKeys(new ForeignKey[0]);
        fetchPerspective.setOperationTypes(new OperationTypes(OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY));
        fetchPerspective.setAdditionalNonPersistentProperties(new String[0]);
        DynamicResultSet resultSet = ((PersistenceManager)helper).fetch(fetchPackage, new CriteriaTransferObject());
        String[][] enums = new String[resultSet.getRecords().length][2];
        int j = 0;
        for (Entity entity : resultSet.getRecords()) {
            enums[j][0] = entity.findProperty("localeCode").getValue();
            enums[j][1] = entity.findProperty("friendlyName").getValue();
            ++j;
        }
        fieldMetadata.setEnumerationValues(enums);
        FieldPresentationAttributes attributes = new FieldPresentationAttributes();
        fieldMetadata.setPresentationAttributes(attributes);
        attributes.setName("locale");
        attributes.setFriendlyName("Locale");
        attributes.setGroup("Description");
        attributes.setOrder(Integer.valueOf(3));
        attributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        attributes.setProminent(Boolean.valueOf(true));
        attributes.setBroadleafEnumeration("");
        attributes.setReadOnly(Boolean.valueOf(false));
        attributes.setVisibility(VisibilityEnum.VISIBLE_ALL);
        attributes.setRequiredOverride(Boolean.valueOf(true));
        mergedProperties.put("locale", fieldMetadata);
        FieldMetadata contentTypeFieldMetadata = new FieldMetadata();
        contentTypeFieldMetadata.setFieldType(SupportedFieldType.EXPLICIT_ENUMERATION);
        contentTypeFieldMetadata.setMutable(Boolean.valueOf(true));
        contentTypeFieldMetadata.setInheritedFromType(StructuredContentTypeImpl.class.getName());
        contentTypeFieldMetadata.setAvailableToTypes(new String[]{StructuredContentTypeImpl.class.getName()});
        contentTypeFieldMetadata.setCollection(Boolean.valueOf(false));
        contentTypeFieldMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        PersistencePackage contentTypeFetchPackage = new PersistencePackage();
        contentTypeFetchPackage.setCeilingEntityFullyQualifiedClassname(StructuredContentType.class.getName());
        PersistencePerspective contentTypeFetchPerspective = new PersistencePerspective();
        contentTypeFetchPackage.setPersistencePerspective(contentTypeFetchPerspective);
        contentTypeFetchPerspective.setAdditionalForeignKeys(new ForeignKey[0]);
        contentTypeFetchPerspective.setOperationTypes(new OperationTypes(OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY));
        contentTypeFetchPerspective.setAdditionalNonPersistentProperties(new String[0]);
        DynamicResultSet contentTypeResultSet = ((PersistenceManager)helper).fetch(contentTypeFetchPackage, new CriteriaTransferObject());
        String[][] contentTypeEnums = new String[contentTypeResultSet.getRecords().length][2];
        int i = 0;
        for (Entity entity : contentTypeResultSet.getRecords()) {
            contentTypeEnums[i][0] = entity.findProperty("id").getValue();
            contentTypeEnums[i][1] = entity.findProperty("name").getValue();
            ++i;
        }
        contentTypeFieldMetadata.setEnumerationValues(contentTypeEnums);
        FieldPresentationAttributes contentTypeAttributes = new FieldPresentationAttributes();
        contentTypeFieldMetadata.setPresentationAttributes(contentTypeAttributes);
        contentTypeAttributes.setName("structuredContentType_Grid");
        contentTypeAttributes.setFriendlyName("Content Type");
        contentTypeAttributes.setGroup("Description");
        contentTypeAttributes.setOrder(Integer.valueOf(2));
        contentTypeAttributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        contentTypeAttributes.setProminent(Boolean.valueOf(true));
        contentTypeAttributes.setBroadleafEnumeration("");
        contentTypeAttributes.setReadOnly(Boolean.valueOf(false));
        contentTypeAttributes.setVisibility(VisibilityEnum.FORM_HIDDEN);
        contentTypeAttributes.setRequiredOverride(Boolean.valueOf(true));
        mergedProperties.put("structuredContentType_Grid", contentTypeFieldMetadata);
        FieldMetadata iconMetadata = new FieldMetadata();
        iconMetadata.setFieldType(SupportedFieldType.ASSET);
        iconMetadata.setMutable(Boolean.valueOf(true));
        iconMetadata.setInheritedFromType(StructuredContentImpl.class.getName());
        iconMetadata.setAvailableToTypes(new String[]{StructuredContentImpl.class.getName()});
        iconMetadata.setCollection(Boolean.valueOf(false));
        iconMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        FieldPresentationAttributes iconAttributes = new FieldPresentationAttributes();
        iconMetadata.setPresentationAttributes(iconAttributes);
        iconAttributes.setName("picture");
        iconAttributes.setFriendlyName(" ");
        iconAttributes.setGroup("Locked Details");
        iconAttributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        iconAttributes.setProminent(Boolean.valueOf(true));
        iconAttributes.setBroadleafEnumeration("");
        iconAttributes.setReadOnly(Boolean.valueOf(false));
        iconAttributes.setVisibility(VisibilityEnum.FORM_HIDDEN);
        iconAttributes.setColumnWidth("25");
        iconAttributes.setOrder(Integer.valueOf(0));
        iconAttributes.setRequiredOverride(Boolean.valueOf(true));
        mergedProperties.put("locked", iconMetadata);
        mergedProperties.put("timeRule", this.createHiddenField("timeRule"));
        mergedProperties.put("requestRule", this.createHiddenField("requestRule"));
        mergedProperties.put("customerRule", this.createHiddenField("customerRule"));
        mergedProperties.put("productRule", this.createHiddenField("productRule"));
    }

    protected FieldMetadata createHiddenField(String name) {
        FieldMetadata fieldMetadata = new FieldMetadata();
        fieldMetadata.setFieldType(SupportedFieldType.HIDDEN);
        fieldMetadata.setMutable(Boolean.valueOf(true));
        fieldMetadata.setInheritedFromType(StaticAssetImpl.class.getName());
        fieldMetadata.setAvailableToTypes(new String[]{StaticAssetImpl.class.getName()});
        fieldMetadata.setCollection(Boolean.valueOf(false));
        fieldMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        FieldPresentationAttributes attributes = new FieldPresentationAttributes();
        fieldMetadata.setPresentationAttributes(attributes);
        attributes.setName(name);
        attributes.setFriendlyName(name);
        attributes.setGroup("Rules");
        attributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        attributes.setProminent(Boolean.valueOf(false));
        attributes.setBroadleafEnumeration("");
        attributes.setReadOnly(Boolean.valueOf(false));
        attributes.setVisibility(VisibilityEnum.HIDDEN_ALL);
        return fieldMetadata;
    }

    public DynamicResultSet inspect(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, InspectHelper helper) throws ServiceException {
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            HashMap<MergedPropertyType, Map<String, FieldMetadata>> allMergedProperties = new HashMap<MergedPropertyType, Map<String, FieldMetadata>>();
            if (this.getModifiedProperties() == null) {
                this.createModifiedProperties(dynamicEntityDao, helper, persistencePerspective);
            }
            Map<String, FieldMetadata> originalProps = this.getModifiedProperties();
            allMergedProperties.put(MergedPropertyType.PRIMARY, originalProps);
            Class[] entityClasses = dynamicEntityDao.getAllPolymorphicEntitiesFromCeiling(StructuredContent.class);
            ClassMetadata mergedMetadata = helper.getMergedClassMetadata(entityClasses, allMergedProperties);
            DynamicResultSet results = new DynamicResultSet(mergedMetadata, null, null);
            return results;
        }
        catch (Exception e) {
            ServiceException ex = new ServiceException("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname(), (Throwable)e);
            this.LOG.error((Object)("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname()), (Throwable)ex);
            throw ex;
        }
    }

    public DynamicResultSet fetch(PersistencePackage persistencePackage, CriteriaTransferObject cto, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        try {
            Entity[] structuredContentEntities;
            if (cto.get("structuredContentType_Grid").getFilterValues().length > 0) {
                CriteriaTransferObject ctoCopy = new CriteriaTransferObject();
                for (String prop : cto.getPropertyIdSet()) {
                    String propertyId = prop.equals("structuredContentType_Grid") ? "structuredContentType" : prop;
                    FilterAndSortCriteria criteria = ctoCopy.get(propertyId);
                    FilterAndSortCriteria oldCriteria = cto.get(prop);
                    criteria.setFilterValue(oldCriteria.getFilterValues()[0]);
                    criteria.setIgnoreCase(oldCriteria.getIgnoreCase());
                    criteria.setSortAscending(oldCriteria.getIgnoreCase());
                }
                cto = ctoCopy;
            }
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map originalProps = helper.getSimpleMergedProperties(StructuredContent.class.getName(), persistencePerspective);
            BaseCtoConverter ctoConverter = helper.getCtoConverter(persistencePerspective, cto, StructuredContent.class.getName(), originalProps);
            PersistentEntityCriteria queryCriteria = ctoConverter.convert(cto, StructuredContent.class.getName());
            PersistentEntityCriteria countCriteria = ctoConverter.convert(new CriteriaTransferObjectCountWrapper(cto).wrap(), StructuredContent.class.getName());
            Criteria criteria = dynamicEntityDao.getCriteria(queryCriteria, StructuredContent.class);
            Criteria count = dynamicEntityDao.getCriteria(countCriteria, StructuredContent.class);
            List<StructuredContent> contents = this.structuredContentService.findContentItems(this.getSandBox(), criteria);
            Long totalRecords = this.structuredContentService.countContentItems(this.getSandBox(), count);
            ArrayList<StructuredContent> convertedList = new ArrayList<StructuredContent>();
            convertedList.addAll(contents);
            for (Entity entity : structuredContentEntities = helper.getRecords(originalProps, convertedList)) {
                Property property;
                if ("true".equals(entity.findProperty("lockedFlag").getValue())) {
                    property = new Property();
                    property.setName("locked");
                    property.setValue("[ISOMORPHIC]/../admin/images/lock_page.png");
                    entity.addProperty(property);
                }
                if (entity.findProperty("structuredContentType") == null) continue;
                property = new Property();
                property.setName("structuredContentType_Grid");
                property.setValue(entity.findProperty("structuredContentType").getValue());
                entity.addProperty(property);
            }
            for (int j = 0; j < structuredContentEntities.length; ++j) {
                this.addRulesToEntity(contents.get(j), structuredContentEntities[j]);
            }
            DynamicResultSet response = new DynamicResultSet(structuredContentEntities, Integer.valueOf(totalRecords.intValue()));
            return response;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to perform fetch for entity: " + ceilingEntityFullyQualifiedClassname, (Throwable)e);
        }
    }

    protected void addRulesToEntity(StructuredContent structuredContent, Entity structuredContentEntity) {
        Entity entity = structuredContentEntity;
        StructuredContent content = structuredContent;
        if (content.getStructuredContentMatchRules() != null) {
            for (String key : content.getStructuredContentMatchRules().keySet()) {
                StructuredContentRuleType type = StructuredContentRuleType.getInstance(key);
                Property prop = null;
                if (StructuredContentRuleType.CUSTOMER.equals(type)) {
                    prop = new Property();
                    prop.setName("customerRule");
                } else if (StructuredContentRuleType.PRODUCT.equals(type)) {
                    prop = new Property();
                    prop.setName("productRule");
                } else if (StructuredContentRuleType.REQUEST.equals(type)) {
                    prop = new Property();
                    prop.setName("requestRule");
                } else if (StructuredContentRuleType.TIME.equals(type)) {
                    prop = new Property();
                    prop.setName("timeRule");
                }
                if (prop == null) continue;
                prop.setValue(content.getStructuredContentMatchRules().get(key).getMatchRule());
                entity.addProperty(prop);
            }
        }
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            StructuredContent adminInstance = (StructuredContent)Class.forName(entity.getType()[0]).newInstance();
            Map adminProperties = helper.getSimpleMergedProperties(StructuredContent.class.getName(), persistencePerspective);
            adminInstance = (StructuredContent)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            this.addRule(entity, adminInstance, "customerRule", StructuredContentRuleType.CUSTOMER);
            this.addRule(entity, adminInstance, "productRule", StructuredContentRuleType.PRODUCT);
            this.addRule(entity, adminInstance, "requestRule", StructuredContentRuleType.REQUEST);
            this.addRule(entity, adminInstance, "timeRule", StructuredContentRuleType.TIME);
            adminInstance = this.structuredContentService.addStructuredContent(adminInstance, this.getSandBox());
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            if (adminEntity.findProperty("structuredContentType") != null) {
                Property property = new Property();
                property.setName("structuredContentType_Grid");
                property.setValue(adminEntity.findProperty("structuredContentType").getValue());
                adminEntity.addProperty(property);
            }
            this.addRulesToEntity(adminInstance, adminEntity);
            return adminEntity;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public Entity update(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(StructuredContent.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            StructuredContent adminInstance = (StructuredContent)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            adminInstance = (StructuredContent)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            this.updateRule(entity, adminInstance, "customerRule", StructuredContentRuleType.CUSTOMER);
            this.updateRule(entity, adminInstance, "productRule", StructuredContentRuleType.PRODUCT);
            this.updateRule(entity, adminInstance, "requestRule", StructuredContentRuleType.REQUEST);
            this.updateRule(entity, adminInstance, "timeRule", StructuredContentRuleType.TIME);
            adminInstance = this.structuredContentService.updateStructuredContent(adminInstance, this.getSandBox());
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            if (adminEntity.findProperty("structuredContentType") != null) {
                Property property = new Property();
                property.setName("structuredContentType_Grid");
                property.setValue(adminEntity.findProperty("structuredContentType").getValue());
                adminEntity.addProperty(property);
            }
            this.addRulesToEntity(adminInstance, adminEntity);
            return adminEntity;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to update entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public void remove(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(StructuredContent.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            StructuredContent adminInstance = (StructuredContent)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            this.structuredContentService.deleteStructuredContent(adminInstance, this.getSandBox());
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to remove entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    protected void addRule(Entity entity, StructuredContent structuredContentInstance, String propertyName, StructuredContentRuleType type) {
        Property ruleProperty = entity.findProperty(propertyName);
        if (ruleProperty != null && !StringUtils.isEmpty((String)ruleProperty.getValue())) {
            StructuredContentRule rule = (StructuredContentRule)this.entityConfiguration.createEntityInstance(StructuredContentRule.class.getName());
            rule.setMatchRule(ruleProperty.getValue());
            structuredContentInstance.getStructuredContentMatchRules().put(type.getType(), rule);
        }
    }

    protected void updateRule(Entity entity, StructuredContent structuredContentInstance, String propertyName, StructuredContentRuleType type) {
        Property ruleProperty = entity.findProperty(propertyName);
        if (ruleProperty != null && !StringUtils.isEmpty((String)ruleProperty.getValue())) {
            StructuredContentRule rule = structuredContentInstance.getStructuredContentMatchRules().get(type.getType());
            if (rule == null) {
                rule = (StructuredContentRule)this.entityConfiguration.createEntityInstance(StructuredContentRule.class.getName());
            }
            rule.setMatchRule(ruleProperty.getValue());
            structuredContentInstance.getStructuredContentMatchRules().put(type.getType(), rule);
        } else {
            structuredContentInstance.getStructuredContentMatchRules().remove(type.getType());
        }
    }
}

