/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.client.presenter;

import com.google.gwt.core.client.JavaScriptObject;
import com.smartgwt.client.data.DataSource;
import org.broadleafcommerce.cms.admin.client.datasource.file.StaticAssetsTileGridDataSourceFactory;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.callback.TileGridItemSelected;
import org.broadleafcommerce.openadmin.client.callback.TileGridItemSelectedHandler;
import org.broadleafcommerce.openadmin.client.datasource.DataSourceFactory;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.TileGridDataSource;
import org.broadleafcommerce.openadmin.client.presenter.entity.DynamicEntityPresenter;
import org.broadleafcommerce.openadmin.client.setup.AsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.PresenterSetupItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.AssetSearchDialog;

public abstract class HtmlEditingPresenter
extends DynamicEntityPresenter {
    protected AssetSearchDialog assetSearchDialogView;

    public String getTemplatePath() {
        return null;
    }

    public void displayAssetSearchDialog(final JavaScriptObject editor) {
        this.assetSearchDialogView.search("Asset Search", new TileGridItemSelectedHandler(){

            public void onSearchItemSelected(TileGridItemSelected event) {
                String staticAssetFullUrl = BLCMain.assetServerUrlPrefix + event.getRecord().getAttribute("fullUrl");
                String name = event.getRecord().getAttribute("name");
                String fileExtension = event.getRecord().getAttribute("fileExtension");
                String richContent = fileExtension.equals("gif") || fileExtension.equals("jpg") || fileExtension.equals("png") ? "<img title='" + name + "' src='" + staticAssetFullUrl + "' alt='" + name + "'/>" : "<a href='" + staticAssetFullUrl + "'>" + name + "</a>";
                HtmlEditingPresenter.this.insertRichTextContent(editor, richContent);
                HtmlEditingPresenter.this.getDisplay().getDynamicFormDisplay().getSaveButton().enable();
                HtmlEditingPresenter.this.getDisplay().getDynamicFormDisplay().getRefreshButton().enable();
            }
        });
    }

    private native void exposeNativeGetTemplatePath();

    private native void exposeNativeDisplayAssetSearchDialog();

    private native void insertRichTextContent(JavaScriptObject var1, String var2);

    protected String getAdminContext() {
        return BLCMain.adminContext;
    }

    protected String getPreviewUrlPrefix() {
        return BLCMain.storeFrontWebAppPrefix;
    }

    public native void exposeNativeGetPreviewUrlPrefix();

    public native void exposeNativeAdminContext();

    public void setup() {
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("staticAssetTreeDS", (DataSourceFactory)new StaticAssetsTileGridDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource dataSource) {
                TileGridDataSource staticAssetTreeDS = (TileGridDataSource)dataSource;
                HtmlEditingPresenter.this.assetSearchDialogView = new AssetSearchDialog(staticAssetTreeDS);
            }
        }));
    }

    public void bind() {
        super.bind();
        this.exposeNativeGetTemplatePath();
        this.exposeNativeDisplayAssetSearchDialog();
        this.exposeNativeGetPreviewUrlPrefix();
        this.exposeNativeAdminContext();
    }
}

