/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.themes;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.bridje.el.ElEnvironment;
import org.bridje.http.HttpBridletResponse;
import org.bridje.ioc.Application;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.ioc.Ioc;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.thls.Thls;
import org.bridje.vfs.GlobExpr;
import org.bridje.vfs.Path;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VFileInputStream;
import org.bridje.web.i18n.WebI18nServices;
import org.bridje.web.view.EventResult;
import org.bridje.web.view.WebView;
import org.bridje.web.view.controls.Control;
import org.bridje.web.view.state.StateRenderProvider;
import org.bridje.web.view.themes.AssetCompressor;
import org.bridje.web.view.themes.ThemeTool;
import org.bridje.web.view.themes.ThemesTplLoader;

@Component
public class ThemesManager {
    private static final Logger LOG = Logger.getLogger(ThemesManager.class.getName());
    private Configuration ftlCfg;
    @Inject
    private IocContext<Application> context;
    @Inject
    private AssetCompressor[] compressors;
    private Map<String, Object> themeTools;
    @Inject
    private WebI18nServices webI18nServ;
    private Map<String, String> compressedStreams = new HashMap<String, String>();

    @PostConstruct
    public void init() {
        this.themeTools = new HashMap<String, Object>();
        this.context.getClassRepository().forEachClass(ThemeTool.class, (cls, ann) -> this.themeTools.put(ann.name(), this.context.find(cls)));
        this.ftlCfg = new Configuration(Configuration.VERSION_2_3_23);
        this.ftlCfg.setTemplateLoader((TemplateLoader)Ioc.context().find(ThemesTplLoader.class));
        this.ftlCfg.setDefaultEncoding("UTF-8");
        this.ftlCfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        this.ftlCfg.setLogTemplateExceptions(false);
    }

    public void render(WebView view, OutputStream os, StateRenderProvider stateProv) {
        if (view == null) {
            return;
        }
        try (OutputStreamWriter w = new OutputStreamWriter(os, Charset.forName("UTF-8"));){
            String themeName = view.getDefaultTheme();
            if (themeName == null || themeName.isEmpty()) {
                return;
            }
            String templatePath = themeName + "/Theme.ftlh";
            Template tpl = this.ftlCfg.getTemplate(templatePath);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("i18n", this.webI18nServ.getI18nMap());
            data.put("tools", this.themeTools);
            data.put("view", view);
            data.put("env", Thls.get(ElEnvironment.class));
            data.put("stateProvider", stateProv);
            tpl.process(data, (Writer)w);
            ((Writer)w).flush();
        }
        catch (TemplateException | IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void render(Control control, WebView view, OutputStream os, EventResult eventResult, StateRenderProvider stateProv) {
        try (OutputStreamWriter w = new OutputStreamWriter(os, Charset.forName("UTF-8"));){
            String themeName = view.getDefaultTheme();
            String templatePath = themeName + "/Theme.ftlh";
            Template tpl = this.ftlCfg.getTemplate(templatePath);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("i18n", this.webI18nServ.getI18nMap());
            data.put("tools", this.themeTools);
            data.put("view", view);
            data.put("control", control);
            data.put("eventResult", eventResult);
            data.put("env", Thls.get(ElEnvironment.class));
            data.put("stateProvider", stateProv);
            tpl.process(data, (Writer)w);
            ((Writer)w).flush();
        }
        catch (TemplateException | IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public boolean serveResource(String themeName, String resPath, HttpBridletResponse resp) throws IOException {
        VFile f;
        GlobExpr globExpr = new GlobExpr("/web/themes/**/resources/**");
        Path path = new Path("/web/themes/" + themeName + "/resources/" + resPath);
        if (globExpr.globMatches(path.getCanonicalPath()) && (f = new VFile(path)).isFile()) {
            String contentType = f.getMimeType();
            resp.setContentType(contentType);
            try (OutputStream os = resp.getOutputStream();
                 InputStream is = this.findInputStream(f);){
                this.copy(is, os);
                os.flush();
            }
            return true;
        }
        return false;
    }

    private InputStream findInputStream(VFile file) throws FileNotFoundException {
        String content;
        boolean canCompress = true;
        if (canCompress && (content = this.compressedContent(file)) != null) {
            byte[] compressedBytes = content.getBytes(Charset.defaultCharset());
            return new ByteArrayInputStream(compressedBytes);
        }
        return new VFileInputStream(file);
    }

    private String compressedContent(VFile file) {
        AssetCompressor compressor = this.findCompressor(file);
        if (compressor == null) {
            return null;
        }
        String fileStr = file.getPath().toString();
        String content = this.compressedStreams.get(fileStr);
        if (content == null) {
            content = compressor.compress(file);
            this.compressedStreams.put(fileStr, content);
        }
        return content;
    }

    private AssetCompressor findCompressor(VFile file) {
        for (AssetCompressor compressor : this.compressors) {
            if (!compressor.canCompress(file)) continue;
            return compressor;
        }
        return null;
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[1024];
        int bytesCount = is.read(buffer);
        while (bytesCount > -1) {
            os.write(buffer, 0, bytesCount);
            bytesCount = is.read(buffer);
        }
    }
}

