/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.themes;

import java.io.IOException;
import java.util.Arrays;
import org.bridje.http.HttpBridlet;
import org.bridje.http.HttpBridletContext;
import org.bridje.http.HttpBridletRequest;
import org.bridje.http.HttpBridletResponse;
import org.bridje.http.HttpException;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.ioc.InjectNext;
import org.bridje.ioc.Priority;
import org.bridje.web.ReqPathRef;
import org.bridje.web.view.themes.ThemesManager;

@Component
@Priority(value=150)
class ThemesBridlet
implements HttpBridlet {
    @Inject
    private ThemesManager themesMang;
    @InjectNext
    private HttpBridlet nextHandler;

    ThemesBridlet() {
    }

    public boolean handle(HttpBridletContext context) throws IOException, HttpException {
        String[] arrPath;
        HttpBridletRequest req = context.getRequest();
        if (req.getPath().startsWith("/__themes") && (arrPath = ReqPathRef.findCurrentPath(context).split("[//]")).length > 3) {
            String themeName = arrPath[2];
            CharSequence[] arrResPath = Arrays.copyOfRange(arrPath, 3, arrPath.length);
            String resPath = String.join((CharSequence)"/", arrResPath);
            HttpBridletResponse resp = context.getResponse();
            return this.themesMang.serveResource(themeName, resPath, resp);
        }
        return this.nextHandler.handle(context);
    }
}

