/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.state;

import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.el.ElService;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.ioc.IocContext;
import org.bridje.web.WebScope;
import org.bridje.web.view.ViewUtils;
import org.bridje.web.view.state.StateField;
import org.bridje.web.view.state.StateListener;

@Component
public class StateManager {
    private static final Logger LOG = Logger.getLogger(StateManager.class.getName());
    @Inject
    private ElService elServ;
    private Map<Class<?>, Map<Field, String>> stateFields;

    public Map<String, String> createViewState(IocContext<WebScope> ctx) {
        if (this.stateFields == null) {
            this.initStateFields(ctx);
        }
        Map<Class<?>, Object> comps = ((StateListener)ctx.find(StateListener.class)).getStateComps();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (comps != null) {
            comps.forEach((c, i) -> this.fillStateValues((Class<?>)c, i, (Map<String, String>)result));
        }
        return result;
    }

    public String toStateString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            try {
                if (!first) {
                    sb.append("&");
                }
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                first = false;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return sb.toString();
    }

    public String createStringViewState(IocContext<WebScope> ctx) {
        Map<String, String> map = this.createViewState(ctx);
        return this.toStateString(map);
    }

    private void fillStateValues(Class<?> comp, Object inst, Map<String, String> stateValues) {
        Map<Field, String> map = this.stateFields.get(comp);
        if (map != null) {
            map.forEach((f, s) -> this.fillStateValues(inst, (Field)f, (String)s, stateValues));
        }
    }

    private void fillStateValues(Object inst, Field field, String state, Map<String, String> stateValues) {
        try {
            Object val = field.get(inst);
            String cv = (String)this.elServ.convert(val, String.class);
            if (cv != null) {
                stateValues.put(state, cv);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void injectState(IocContext<WebScope> ctx, Class<Object> clazz, Object inst, WebScope req) {
        Map<Field, String> lst;
        if (this.stateFields == null) {
            this.initStateFields(ctx);
        }
        if ((lst = this.stateFields.get(clazz)) != null) {
            lst.forEach((field, stateName) -> this.injectState(inst, (Field)field, (String)stateName, req));
        }
    }

    private void injectState(Object inst, Field field, String stateName, WebScope req) {
        try {
            Object cv;
            String value = req.getStateValue(stateName);
            if (value != null && (cv = this.elServ.convert((Object)value, field.getType())) != null) {
                field.set(inst, cv);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private String findStateFieldName(Class<Object> clazz, Field field) {
        return ViewUtils.simplifyParam(clazz.getName() + "." + field.getName());
    }

    private synchronized void initStateFields(IocContext<WebScope> ctx) {
        if (this.stateFields == null) {
            HashMap result = new HashMap();
            ctx.getClassRepository().forEachField(StateField.class, (field, component, annot) -> {
                HashMap<Field, String> lst = (HashMap<Field, String>)result.get(component);
                if (lst == null) {
                    lst = new HashMap<Field, String>();
                    result.put(component, lst);
                }
                field.setAccessible(true);
                String name = this.findStateFieldName(component, field);
                while (lst.containsValue(name)) {
                    name = name + "_";
                }
                lst.put(field, name);
            });
            this.stateFields = result;
        }
    }
}

