/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.controls;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.bridje.el.ElEnvironment;
import org.bridje.http.UploadedFile;
import org.bridje.ioc.thls.Thls;
import org.bridje.web.view.controls.UIFileExpressionAdapter;

@XmlTransient
@XmlJavaTypeAdapter(value=UIFileExpressionAdapter.class)
public class UIFileExpression {
    private static final Logger LOG = Logger.getLogger(UIFileExpression.class.getName());
    private final String expression;
    private String parameter;

    UIFileExpression(String expression) {
        this.expression = expression;
    }

    public void set(UploadedFile value) {
        if (this.isValid()) {
            ((ElEnvironment)Thls.get(ElEnvironment.class)).set(this.getExpression(), (Object)value);
        }
    }

    public String getParameter() {
        if (this.parameter == null && this.isValid()) {
            this.parameter = this.getExpression().substring(2, this.getExpression().length() - 1);
        }
        return this.parameter;
    }

    public boolean isValid() {
        return this.getExpression().startsWith("${") && this.getExpression().endsWith("}");
    }

    public String getExpression() {
        return this.expression;
    }

    public UploadedFile get() {
        try {
            return (UploadedFile)((ElEnvironment)Thls.get(ElEnvironment.class)).get(this.expression, UploadedFile.class);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "The expression {0} is not valid: {1}", new Object[]{this.expression, e.getMessage()});
            return null;
        }
    }
}

