/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.controls;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.bridje.el.ElEnvironment;
import org.bridje.web.view.Defines;
import org.bridje.web.view.EventResult;
import org.bridje.web.view.controls.Control;
import org.bridje.web.view.controls.ControlCallback;
import org.bridje.web.view.controls.ControlInputReader;
import org.bridje.web.view.controls.UIEvent;
import org.bridje.web.view.controls.UIExpression;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class DynamicControl
extends Control {
    @XmlAttribute
    private UIExpression data;
    @XmlAttribute
    private String var;

    public UIExpression getDataExpression() {
        return this.data;
    }

    public List getData() {
        return DynamicControl.get(this.data, List.class, null);
    }

    public String getVar() {
        if (this.var == null) {
            this.var = null;
        }
        return this.var;
    }

    @Override
    public void doOverride(Map<String, Defines> definesMap) {
    }

    @Override
    public void readInput(ControlInputReader req, ElEnvironment env) {
        for (Object item : this.getData()) {
            env.pushVar("item", item);
            this.inputFiles().stream().forEachOrdered(inputFile -> DynamicControl.set(inputFile, req.popUploadedFile(inputFile.getParameter())));
            this.inputs().stream().forEachOrdered(input -> DynamicControl.set(input, req.popParameter(input.getParameter())));
            this.childs().forEach(control -> control.readInput(req, env));
            env.popVar("item");
        }
    }

    @Override
    public EventResult executeEvent(ControlInputReader req, ElEnvironment env) {
        for (Object item : this.getData()) {
            env.pushVar("item", item);
            for (UIEvent uIEvent : this.events()) {
                if (!this.eventTriggered(req, uIEvent)) continue;
                return this.invokeEvent(uIEvent);
            }
            for (Control control : this.childs()) {
                EventResult result = control.executeEvent(req, env);
                if (result == null) continue;
                return result;
            }
            env.popVar("item");
        }
        return null;
    }

    @Override
    public Control findById(ElEnvironment env, String id, ControlCallback callback) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (Object item : this.getData()) {
            env.pushVar("item", item);
            if (id.equals(this.getId())) {
                callback.process(this);
                return this;
            }
            for (Control control : this.childs()) {
                Control result = control.findById(env, id, callback);
                if (result == null) continue;
                return result;
            }
            env.popVar("item");
        }
        return null;
    }
}

