/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.controls;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.annotation.XmlTransient;
import org.bridje.web.view.WebLayout;
import org.bridje.web.view.WebView;

@SupportedAnnotationTypes(value={"javax.xml.bind.annotation.XmlRootElement"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@XmlTransient
public class ControlProcessor
extends AbstractProcessor {
    private Writer writer;
    private static final Logger LOG = Logger.getLogger(ControlProcessor.class.getName());
    public static final String CONTROLS_RESOURCE_FILE = "BRIDJE-INF/web/controls.properties";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Messager messager = processingEnv.getMessager();
        try {
            Filer filer = processingEnv.getFiler();
            FileObject fobj = filer.createResource(StandardLocation.CLASS_OUTPUT, "", CONTROLS_RESOURCE_FILE, new Element[0]);
            this.writer = fobj.openWriter();
        }
        catch (IOException e) {
            messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            LOG.severe(e.getMessage());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        try {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> ann = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : ann) {
                    if (element.getKind() != ElementKind.CLASS || !this.isControl((TypeElement)element)) continue;
                    String clsName = element.toString();
                    this.appendClass(clsName, "");
                }
            }
        }
        catch (IOException ex) {
            messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            LOG.severe(ex.getMessage());
        }
        return false;
    }

    private void appendClass(String clsName, String val) throws IOException {
        this.writer.append(clsName);
        this.writer.append("=");
        this.writer.append(val);
        this.writer.append('\n');
        this.writer.flush();
    }

    private boolean isControl(TypeElement element) {
        List<? extends TypeMirror> interfaces = element.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (typeMirror.toString().equalsIgnoreCase(WebView.class.getName())) {
                return true;
            }
            if (!typeMirror.toString().equalsIgnoreCase(WebLayout.class.getName())) continue;
            return true;
        }
        return false;
    }
}

