/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.controls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlTransient;
import org.bridje.ioc.Component;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VFileInputStream;
import org.bridje.vfs.VFileOutputStream;
import org.bridje.web.view.AbstractView;
import org.bridje.web.view.WebView;

@Component
@XmlTransient
public class ControlManager {
    private static final Logger LOG = Logger.getLogger(ControlManager.class.getName());
    private Unmarshaller webViewUnmarsh;
    private Marshaller webViewMarsh;

    @PostConstruct
    private void init() {
        try {
            JAXBContext webViewJaxbCtx = JAXBContext.newInstance((Class[])this.findComponentsClasses());
            this.webViewUnmarsh = webViewJaxbCtx.createUnmarshaller();
            this.webViewMarsh = webViewJaxbCtx.createMarshaller();
        }
        catch (IOException | JAXBException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public <T> T read(VFile vf, Class<T> resultCls) throws IOException {
        try {
            return resultCls.cast(this.toWebView(vf));
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public <T> void write(VFile vf, T contentObj) throws IOException {
        this.writeWebView(vf, (WebView)contentObj);
    }

    private Class<?>[] findComponentsClasses() throws IOException {
        ArrayList result = new ArrayList();
        List<URL> files = this.findModelsFiles();
        files.stream().map(this::readFile).forEach(prop -> this.readClasses(result, (Properties)prop));
        String ctrlClasses = result.stream().map(c -> c.toString()).collect(Collectors.joining("\n - "));
        LOG.log(Level.INFO, "Control Classes:\n - {0}", ctrlClasses);
        Class[] arr = new Class[result.size()];
        return result.toArray(arr);
    }

    private Properties readFile(URL url) {
        Properties prop = new Properties();
        try (InputStream is = url.openStream();){
            prop.load(is);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return prop;
    }

    private List<URL> findModelsFiles() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = ccl.getResources("BRIDJE-INF/web/controls.properties");
        while (resources.hasMoreElements()) {
            URL nextElement = resources.nextElement();
            urls.add(nextElement);
        }
        return urls;
    }

    private void readClasses(List<Class<?>> result, Properties prop) {
        prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            try {
                Class<?> cls = Class.forName((String)k);
                if (!result.contains(cls)) {
                    result.add(cls);
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractView toWebView(VFile f) {
        try (VFileInputStream is = new VFileInputStream(f);){
            Object unmObj = this.webViewUnmarsh.unmarshal((InputStream)is);
            if (!(unmObj instanceof AbstractView)) return null;
            AbstractView abstractView = (AbstractView)unmObj;
            return abstractView;
        }
        catch (IOException | JAXBException ex) {
            LOG.log(Level.SEVERE, "Could not load the  view " + f.getPath() + " " + ex.getMessage(), ex);
        }
        return null;
    }

    private void writeWebView(VFile f, WebView view) {
        try (VFileOutputStream os = new VFileOutputStream(f);){
            this.webViewMarsh.marshal((Object)view, (OutputStream)os);
        }
        catch (IOException | JAXBException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

