/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bridje.http.HttpBridletRequest;
import org.bridje.http.HttpReqParam;
import org.bridje.http.UploadedFile;

public class ControlInputReader {
    private final Map<String, List<UploadedFile>> filesMap = new LinkedHashMap<String, List<UploadedFile>>();
    private final Map<String, List<HttpReqParam>> parametersMap = new LinkedHashMap<String, List<HttpReqParam>>();

    public ControlInputReader(HttpBridletRequest req) {
        UploadedFile[] files;
        for (UploadedFile file : files = req.getAllUploadedFiles()) {
            List<UploadedFile> lst = this.filesMap.get(file.getName());
            if (lst == null) {
                lst = new ArrayList<UploadedFile>();
                this.filesMap.put(file.getName(), lst);
            }
            lst.add(file);
        }
        Map postParameters = req.getPostParameters();
        for (Map.Entry param : postParameters.entrySet()) {
            List<HttpReqParam> lst = this.parametersMap.get(param.getKey());
            if (lst == null) {
                lst = new ArrayList<HttpReqParam>();
                this.parametersMap.put((String)param.getKey(), lst);
            }
            lst.addAll(Arrays.asList(((HttpReqParam)param.getValue()).separate()));
        }
    }

    public UploadedFile getUploadedFile(String parameter) {
        List<UploadedFile> result = this.filesMap.get(parameter);
        if (result != null && !result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    public UploadedFile popUploadedFile(String parameter) {
        List<UploadedFile> result = this.filesMap.get(parameter);
        if (result != null && !result.isEmpty()) {
            UploadedFile file = result.get(0);
            if (file != null) {
                result.remove(0);
            }
            if (result.isEmpty()) {
                this.filesMap.remove(parameter);
            }
            return file;
        }
        return null;
    }

    public HttpReqParam getParameter(String parameter) {
        List<HttpReqParam> result = this.parametersMap.get(parameter);
        if (result != null && !result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    public HttpReqParam popParameter(String parameter) {
        List<HttpReqParam> result = this.parametersMap.get(parameter);
        if (result != null && !result.isEmpty()) {
            HttpReqParam param = result.get(0);
            if (param != null) {
                result.remove(0);
            }
            if (result.isEmpty()) {
                this.parametersMap.remove(parameter);
            }
            return param;
        }
        return null;
    }
}

