/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view.controls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.bridje.el.ElEnvironment;
import org.bridje.http.HttpReqParam;
import org.bridje.http.UploadedFile;
import org.bridje.ioc.thls.Thls;
import org.bridje.ioc.thls.ThlsAction;
import org.bridje.web.view.Defines;
import org.bridje.web.view.EventResult;
import org.bridje.web.view.controls.ControlCallback;
import org.bridje.web.view.controls.ControlInputReader;
import org.bridje.web.view.controls.ControlPlaceHolder;
import org.bridje.web.view.controls.UIEvent;
import org.bridje.web.view.controls.UIExpression;
import org.bridje.web.view.controls.UIFileExpression;
import org.bridje.web.view.controls.UIInputExpression;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlTransient
public abstract class Control {
    private static final Logger LOG = Logger.getLogger(Control.class.getName());
    @XmlAttribute
    private UIExpression id;

    public static <T> T get(UIExpression expression, Class<T> resultClass, T def) {
        T result;
        if (expression != null && (result = expression.get(resultClass)) != null) {
            return result;
        }
        return def;
    }

    public static UploadedFile get(UIFileExpression expression) {
        if (expression != null) {
            return expression.get();
        }
        return null;
    }

    public static void set(UIInputExpression expression, HttpReqParam param) {
        if (param != null && expression != null && expression.isValid()) {
            expression.set(param);
        }
    }

    public static void set(UIFileExpression expression, UploadedFile file) {
        if (file != null && expression != null && expression.isValid()) {
            expression.set(file);
        }
    }

    public String getId() {
        return Control.get(this.id, String.class, null);
    }

    public List<UIInputExpression> inputs() {
        return Collections.emptyList();
    }

    public List<UIFileExpression> inputFiles() {
        return Collections.emptyList();
    }

    public List<UIEvent> events() {
        return Collections.emptyList();
    }

    public List<? extends Control> childs() {
        return Collections.emptyList();
    }

    public List<String> resources() {
        return Collections.emptyList();
    }

    public Control findById(ElEnvironment env, String id, ControlCallback callback) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (id.equals(this.getId())) {
            callback.process(this);
            return this;
        }
        for (Control control : this.childs()) {
            Control result = control.findById(env, id, callback);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void readInput(ControlInputReader req, ElEnvironment env) {
        this.inputFiles().stream().forEachOrdered(inputFile -> Control.set(inputFile, req.popUploadedFile(inputFile.getParameter())));
        this.inputs().stream().forEachOrdered(input -> Control.set(input, req.popParameter(input.getParameter())));
        this.childs().forEach(control -> control.readInput(req, env));
    }

    public EventResult executeEvent(ControlInputReader req, ElEnvironment env) {
        for (UIEvent uIEvent : this.events()) {
            if (!this.eventTriggered(req, uIEvent)) continue;
            return this.invokeEvent(uIEvent);
        }
        for (Control control : this.childs()) {
            EventResult result = control.executeEvent(req, env);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public EventResult invokeEvent(final UIEvent event) {
        return (EventResult)Thls.doAs((ThlsAction)new ThlsAction<EventResult>(){

            public EventResult execute() {
                try {
                    Object res = event.invoke();
                    if (res instanceof EventResult) {
                        return (EventResult)res;
                    }
                    return EventResult.of(null, null, res, null);
                }
                catch (ELException e) {
                    if (e.getCause() != null && e.getCause() instanceof Exception) {
                        Exception real = (Exception)e.getCause();
                        LOG.log(Level.SEVERE, real.getMessage(), real);
                        return EventResult.error(real.getMessage(), real);
                    }
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    return EventResult.error(e.getMessage(), (Exception)((Object)e));
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    return EventResult.error(e.getMessage(), e);
                }
            }
        }, UIEvent.class, (Object)event);
    }

    public boolean eventTriggered(ControlInputReader req, UIEvent event) {
        HttpReqParam param = req.popParameter(event.getParameter());
        if (param != null) {
            return "t".equals(param.getValue());
        }
        return false;
    }

    public void override(Map<String, Defines> definesMap) {
        this.doOverride(definesMap);
        this.childs().forEach(control -> control.override(definesMap));
    }

    public static List<Control> doOverride(List<Control> children, Map<String, Defines> definesMap) {
        ArrayList<Control> result = new ArrayList<Control>();
        for (Control control : children) {
            if (control instanceof ControlPlaceHolder) {
                ControlPlaceHolder ph = (ControlPlaceHolder)control;
                Defines def = definesMap.get(ph.getName());
                if (def == null || def.getControls() == null) continue;
                result.addAll(def.getControls());
                continue;
            }
            result.add(control);
        }
        return result;
    }

    public static Control doOverride(Control child, Map<String, Defines> definesMap) {
        Control result = null;
        if (child instanceof ControlPlaceHolder) {
            ControlPlaceHolder ph = (ControlPlaceHolder)child;
            Defines def = definesMap.get(ph.getName());
            if (def != null && def.getControl() != null) {
                result = def.getControl();
            }
        } else {
            result = child;
        }
        return result;
    }

    public abstract void doOverride(Map<String, Defines> var1);
}

