/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.xml.bind.annotation.XmlTransient;
import org.bridje.el.ElEnvironment;
import org.bridje.el.ElService;
import org.bridje.http.HttpBridletContext;
import org.bridje.http.HttpBridletRequest;
import org.bridje.http.HttpBridletResponse;
import org.bridje.http.HttpException;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.thls.Thls;
import org.bridje.vfs.GlobExpr;
import org.bridje.vfs.Path;
import org.bridje.vfs.VFile;
import org.bridje.web.RedirectTo;
import org.bridje.web.ReqPathRef;
import org.bridje.web.WebScope;
import org.bridje.web.i18n.WebI18nServices;
import org.bridje.web.view.EventResult;
import org.bridje.web.view.WebLayoutManager;
import org.bridje.web.view.WebView;
import org.bridje.web.view.WebViewRef;
import org.bridje.web.view.controls.ControlInputReader;
import org.bridje.web.view.controls.ControlManager;
import org.bridje.web.view.state.StateManager;
import org.bridje.web.view.themes.ThemesManager;

@Component
@XmlTransient
public class WebViewsManager {
    private static final Logger LOG = Logger.getLogger(WebViewsManager.class.getName());
    @Inject
    private ControlManager controlManag;
    @Inject
    private ThemesManager themesMang;
    @Inject
    private ElService elServ;
    @Inject
    private StateManager stateManag;
    @Inject
    private WebLayoutManager layoutManag;
    @Inject
    private WebI18nServices webI18nServ;
    private Map<String, WebView> views;
    private final Path basePath = new Path("/web");

    @PostConstruct
    public void init() {
        this.initViews();
    }

    public WebView findView(String path) {
        return this.views.get(path);
    }

    public WebView findView(HttpBridletContext context) {
        String viewName = this.findViewName(context);
        return this.findView(viewName);
    }

    public WebView findUpdateView(HttpBridletContext context) throws HttpException {
        String viewName = this.findUpdateViewName(context);
        if (viewName != null) {
            WebView view = this.findView(viewName);
            if (view == null) {
                throw new HttpException(400, "Bad Request");
            }
            return view;
        }
        return null;
    }

    public boolean isUpdateView(HttpBridletContext context) {
        return this.findUpdateViewName(context) != null;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public String findUpdateViewName(HttpBridletContext context) {
        HttpBridletRequest req = context.getRequest();
        String viewUpdate = req.getHeader("Bridje-View");
        if (viewUpdate != null && !viewUpdate.isEmpty()) {
            return viewUpdate;
        }
        return null;
    }

    public void renderView(WebView view, HttpBridletContext context, Map<String, Object> params) {
        if (view == null) {
            return;
        }
        IocContext wrsCtx = (IocContext)context.get(IocContext.class);
        HttpBridletResponse resp = context.getResponse();
        try (OutputStream os = resp.getOutputStream();){
            ElEnvironment elEnv = this.elServ.createElEnvironment(wrsCtx);
            elEnv.pushVar("view", (Object)view);
            elEnv.pushVar("i18n", this.webI18nServ.getI18nMap());
            elEnv.pushVar("params", params);
            elEnv.pushVar("eventResult", (Object)EventResult.none());
            Thls.doAsEx(() -> {
                this.themesMang.render(view, os, () -> this.stateManag.createStringViewState((IocContext<WebScope>)wrsCtx));
                os.flush();
                return null;
            }, ElEnvironment.class, (Object)elEnv);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void renderView(WebView view, HttpBridletContext context) {
        IocContext wrsCtx = (IocContext)context.get(IocContext.class);
        HttpBridletResponse resp = context.getResponse();
        try (OutputStream os = resp.getOutputStream();){
            ElEnvironment elEnv = this.elServ.createElEnvironment(wrsCtx);
            elEnv.pushVar("view", (Object)view);
            elEnv.pushVar("i18n", this.webI18nServ.getI18nMap());
            elEnv.pushVar("eventResult", (Object)EventResult.none());
            Thls.doAsEx(() -> {
                this.themesMang.render(view, os, () -> this.stateManag.createStringViewState((IocContext<WebScope>)wrsCtx));
                os.flush();
                return null;
            }, ElEnvironment.class, (Object)elEnv);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void updateView(WebView view, HttpBridletContext context) {
        IocContext wrsCtx = (IocContext)context.get(IocContext.class);
        HttpBridletRequest req = context.getRequest();
        ElEnvironment elEnv = this.elServ.createElEnvironment(wrsCtx);
        Thls.doAs(() -> {
            view.getRoot().findById(elEnv, req.getHeader("Bridje-Container"), ctrl -> {
                ctrl.readInput(new ControlInputReader(req), elEnv);
                EventResult result = ctrl.executeEvent(new ControlInputReader(req), elEnv);
                if (result == null) {
                    result = EventResult.none();
                }
                if (result.getData() != null && result.getData() instanceof RedirectTo) {
                    RedirectTo redirectTo = (RedirectTo)result.getData();
                    context.getResponse().setHeader("Bridje-Location", (Object)redirectTo.getResource());
                } else {
                    elEnv.pushVar("view", (Object)view);
                    elEnv.pushVar("i18n", this.webI18nServ.getI18nMap());
                    elEnv.pushVar("eventResult", (Object)result);
                    elEnv.pushVar("control", (Object)ctrl);
                    HttpBridletResponse resp = context.getResponse();
                    try (OutputStream os = resp.getOutputStream();){
                        this.themesMang.render(ctrl, view, os, result, () -> this.stateManag.createStringViewState((IocContext<WebScope>)wrsCtx));
                        os.flush();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    context.getResponse().setHeader("Bridje-State", (Object)this.stateManag.createStringViewState((IocContext<WebScope>)wrsCtx));
                }
            });
            return null;
        }, ElEnvironment.class, (Object)elEnv);
    }

    public void renderPartialView(WebView view, HttpBridletContext context, EventResult result, Map<String, Object> params) {
        IocContext wrsCtx = (IocContext)context.get(IocContext.class);
        try {
            ElEnvironment elEnv = this.elServ.createElEnvironment(wrsCtx);
            Thls.doAsEx(() -> {
                elEnv.pushVar("view", (Object)view);
                elEnv.pushVar("i18n", this.webI18nServ.getI18nMap());
                elEnv.pushVar("params", (Object)params);
                elEnv.pushVar("eventResult", (Object)result);
                HttpBridletResponse resp = context.getResponse();
                try (OutputStream os = resp.getOutputStream();){
                    this.themesMang.render(view.getRoot(), view, os, result, () -> this.stateManag.createStringViewState((IocContext<WebScope>)wrsCtx));
                    os.flush();
                }
                return null;
            }, ElEnvironment.class, (Object)elEnv);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String findViewName(HttpBridletContext context) {
        WebViewRef viewRef = (WebViewRef)context.get(WebViewRef.class);
        if (viewRef != null && viewRef.getViewPath() != null) {
            return viewRef.getViewPath();
        }
        return "/public" + ReqPathRef.findCurrentPath(context);
    }

    private void initViews() {
        this.views = new HashMap<String, WebView>();
        VFile publicFolder = new VFile(this.basePath);
        if (publicFolder.isDirectory()) {
            GlobExpr exp = new GlobExpr("**.view.xml");
            VFile[] files = publicFolder.search(exp);
            Arrays.asList(files).forEach(this::readView);
        }
    }

    private void readView(VFile f) {
        try {
            WebView view = this.controlManag.read(f, WebView.class);
            if (view != null) {
                view.setFile(f);
                this.views.put(view.getName(), view);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not parse " + f.getPath() + ". " + e.getMessage(), e);
        }
    }
}

