/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.vfs.Path;
import org.bridje.vfs.VFile;
import org.bridje.web.view.AbstractView;
import org.bridje.web.view.WebLayout;
import org.bridje.web.view.controls.ControlManager;

@Component
@XmlTransient
public class WebLayoutManager {
    private static final Logger LOG = Logger.getLogger(WebLayoutManager.class.getName());
    @Inject
    private ControlManager controlManag;

    public WebLayout loadLayout(AbstractView currentView, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        VFile file = name.startsWith("/") ? new VFile(new Path("/web").join(name + ".layout.xml")) : new VFile(currentView.getFile().getParent().getPath().join(name + ".layout.xml"));
        if (!file.isFile()) {
            LOG.log(Level.WARNING, "Could not load parent layout {0}", name);
            return null;
        }
        return this.readLayout(file);
    }

    private WebLayout readLayout(VFile f) {
        try {
            return this.controlManag.read(f, WebLayout.class);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

