/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view;

import org.bridje.web.view.EventResultType;

public class FieldStatusInf {
    private final String fieldName;
    private final EventResultType status;
    private final String message;

    private FieldStatusInf(String fieldName, EventResultType status, String message) {
        this.fieldName = fieldName;
        this.status = status;
        this.message = message;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public EventResultType getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public static FieldStatusInf error(String fieldName) {
        return FieldStatusInf.custom(fieldName, EventResultType.ERROR, null);
    }

    public static FieldStatusInf warn(String fieldName) {
        return FieldStatusInf.custom(fieldName, EventResultType.WARNING, null);
    }

    public static FieldStatusInf success(String fieldName) {
        return FieldStatusInf.custom(fieldName, EventResultType.SUCCESS, null);
    }

    public static FieldStatusInf info(String fieldName) {
        return FieldStatusInf.custom(fieldName, EventResultType.INFO, null);
    }

    public static FieldStatusInf error(String fieldName, String message) {
        return FieldStatusInf.custom(fieldName, EventResultType.ERROR, message);
    }

    public static FieldStatusInf warn(String fieldName, String message) {
        return FieldStatusInf.custom(fieldName, EventResultType.WARNING, message);
    }

    public static FieldStatusInf success(String fieldName, String message) {
        return FieldStatusInf.custom(fieldName, EventResultType.SUCCESS, message);
    }

    public static FieldStatusInf info(String fieldName, String message) {
        return FieldStatusInf.custom(fieldName, EventResultType.INFO, message);
    }

    public static FieldStatusInf custom(String fieldName, EventResultType status, String message) {
        return new FieldStatusInf(fieldName, status, message);
    }
}

