/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.view;

import java.util.Arrays;
import java.util.List;
import org.bridje.ioc.thls.Thls;
import org.bridje.web.view.EventResultType;
import org.bridje.web.view.FieldStatusInf;
import org.bridje.web.view.controls.UIEvent;

public class EventResult {
    private final UIEvent event = (UIEvent)Thls.get(UIEvent.class);
    private final EventResultType type;
    private final String message;
    private final Exception exception;
    private final Object data;
    private final List<FieldStatusInf> fields;

    public static EventResult info(String message, Object data) {
        return new EventResult(EventResultType.INFO, message, data, null, null);
    }

    public static EventResult info(String message, Object data, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.INFO, message, data, null, Arrays.asList(fields));
    }

    public static EventResult info(String message) {
        return new EventResult(EventResultType.INFO, message, null, null, null);
    }

    public static EventResult info(String message, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.INFO, message, null, null, Arrays.asList(fields));
    }

    public static EventResult success(String message, Object data) {
        return new EventResult(EventResultType.SUCCESS, message, data, null, null);
    }

    public static EventResult success(String message, Object data, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.SUCCESS, message, data, null, Arrays.asList(fields));
    }

    public static EventResult success(String message) {
        return new EventResult(EventResultType.SUCCESS, message, null, null, null);
    }

    public static EventResult success(String message, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.SUCCESS, message, null, null, Arrays.asList(fields));
    }

    public static EventResult warn(String message, Object data) {
        return new EventResult(EventResultType.WARNING, message, data, null, null);
    }

    public static EventResult warn(String message, Object data, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.WARNING, message, data, null, Arrays.asList(fields));
    }

    public static EventResult warn(String message) {
        return new EventResult(EventResultType.WARNING, message, null, null, null);
    }

    public static EventResult warn(String message, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.WARNING, message, null, null, Arrays.asList(fields));
    }

    public static EventResult warn(String message, Object data, Exception exception) {
        return new EventResult(EventResultType.WARNING, message, data, null, null);
    }

    public static EventResult warn(String message, Object data, Exception exception, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.WARNING, message, data, null, Arrays.asList(fields));
    }

    public static EventResult error(String message, Exception exception) {
        return new EventResult(EventResultType.ERROR, message, null, exception, null);
    }

    public static EventResult error(String message) {
        return new EventResult(EventResultType.ERROR, message, null, null, null);
    }

    public static EventResult error(String message, Exception exception, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.ERROR, message, null, exception, Arrays.asList(fields));
    }

    public static EventResult error(String message, FieldStatusInf ... fields) {
        return new EventResult(EventResultType.ERROR, message, null, null, Arrays.asList(fields));
    }

    public static EventResult of(EventResultType type, String message, Object data, Exception exception) {
        return new EventResult(type, message, data, exception, null);
    }

    public static EventResult of(EventResultType type, String message, Object data, Exception exception, FieldStatusInf ... fields) {
        return new EventResult(type, message, data, exception, Arrays.asList(fields));
    }

    public static EventResult none() {
        return new EventResult(EventResultType.NONE, null, null, null, null);
    }

    private EventResult(EventResultType type, String message, Object data, Exception exception, List<FieldStatusInf> fields) {
        this.type = type;
        this.message = message;
        this.data = data;
        this.exception = exception;
        this.fields = fields;
    }

    public UIEvent getEvent() {
        return this.event;
    }

    public EventResultType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getData() {
        return this.data;
    }

    public List<FieldStatusInf> getFields() {
        return this.fields;
    }

    public boolean hasFieldStatus(String name) {
        if (this.fields == null) {
            return false;
        }
        return this.fields.stream().anyMatch(f -> f.getFieldName().equalsIgnoreCase(name));
    }

    public FieldStatusInf findFieldStatus(String name) {
        if (this.fields == null) {
            return null;
        }
        return this.fields.stream().filter(f -> f.getFieldName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }
}

