/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.session;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.el.ElService;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.ioc.IocContext;
import org.bridje.web.WebScope;
import org.bridje.web.session.WebSession;
import org.bridje.web.session.WebSessionField;

@Component
class WebSessionManager {
    private static final Logger LOG = Logger.getLogger(WebSessionManager.class.getName());
    private Map<Class<?>, Map<Field, String>> sessionFields;
    @Inject
    private ElService elServ;

    WebSessionManager() {
    }

    public String findSessionFieldName(Class<Object> clazz, Field field) {
        return field.getAnnotation(WebSessionField.class).value();
    }

    public Set<Field> injectValue(IocContext<WebScope> ctx, Class<?> clazz, Object instance, WebSession session) {
        Map<Field, String> lst;
        if (this.sessionFields == null) {
            this.initSessionFields(ctx);
        }
        if ((lst = this.sessionFields.get(clazz)) != null) {
            HashSet<Field> result = new HashSet<Field>();
            lst.forEach((field, sessName) -> {
                try {
                    String value = session.find((String)sessName);
                    result.add((Field)field);
                    if (value != null) {
                        field.set(instance, this.unserialize(value, (Field)field));
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            });
            return result;
        }
        return null;
    }

    public Set<Field> storeValue(IocContext<WebScope> ctx, Class<?> clazz, Object instance, WebSession session) {
        if (this.sessionFields == null) {
            this.initSessionFields(ctx);
        }
        HashSet<Field> result = new HashSet<Field>();
        Map<Field, String> lst = this.sessionFields.get(clazz);
        if (lst != null) {
            lst.forEach((field, sessName) -> {
                try {
                    Object value = field.get(instance);
                    session.save((String)sessName, this.serialize(value));
                    result.add((Field)field);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            });
        }
        return result;
    }

    private synchronized void initSessionFields(IocContext<WebScope> ctx) {
        if (this.sessionFields == null) {
            HashMap result = new HashMap();
            ctx.getClassRepository().forEachField(WebSessionField.class, (field, component, annot) -> {
                HashMap<Field, String> lst = (HashMap<Field, String>)result.get(component);
                if (lst == null) {
                    lst = new HashMap<Field, String>();
                    result.put(component, lst);
                }
                field.setAccessible(true);
                String name = this.findSessionFieldName(component, field);
                lst.put(field, name);
            });
            this.sessionFields = result;
        }
    }

    private String serialize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return (String)this.elServ.convert(value, String.class);
    }

    private Object unserialize(String value, Field field) {
        if (value == null) {
            return null;
        }
        if (field.getType().equals(String.class)) {
            return value;
        }
        return this.elServ.convert((Object)value, field.getType());
    }
}

