/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.session;

import java.io.IOException;
import java.util.UUID;
import org.bridje.http.HttpBridlet;
import org.bridje.http.HttpBridletContext;
import org.bridje.http.HttpCookie;
import org.bridje.http.HttpException;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.ioc.InjectNext;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.Priority;
import org.bridje.web.WebScope;
import org.bridje.web.session.WebSession;
import org.bridje.web.session.WebSessionImpl;
import org.bridje.web.session.WebSessionListener;
import org.bridje.web.session.WebSessionManager;
import org.bridje.web.session.WebSessionProvider;

@Component
@Priority(value=200)
class WebSessionBridlet
implements HttpBridlet {
    @InjectNext
    private HttpBridlet nextHandler;
    @Inject
    private WebSessionManager sessionManager;
    @Inject
    private WebSessionProvider sessionProvider;

    WebSessionBridlet() {
    }

    public boolean handle(HttpBridletContext context) throws IOException, HttpException {
        IocContext ctx = (IocContext)context.get(IocContext.class);
        String sessionId = this.findSessionId((WebScope)ctx.getScope());
        WebSessionImpl webSess = new WebSessionImpl(sessionId, this.sessionProvider);
        context.set(WebSession.class, (Object)webSess);
        if (this.nextHandler == null) {
            return false;
        }
        WebSessionListener listener = (WebSessionListener)ctx.find(WebSessionListener.class);
        if (this.nextHandler.handle(context)) {
            listener.getInjectedClasses().forEach((cls, fields) -> this.sessionManager.storeValue((IocContext<WebScope>)ctx, (Class<?>)cls, ctx.find(cls), webSess));
            return true;
        }
        return false;
    }

    public String findSessionId(WebScope req) {
        HttpCookie sessionIdCookie = req.getCookie("sessionid");
        if (sessionIdCookie != null) {
            return sessionIdCookie.getValue();
        }
        String sessionId = UUID.randomUUID().toString();
        sessionIdCookie = req.addCookie("sessionid", sessionId);
        return sessionId;
    }
}

