/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bridje.ioc.Component;
import org.bridje.ioc.Priority;
import org.bridje.web.session.WebSessionProvider;

@Component
@Priority(value=0x7FFFFFFF)
class MemorySessionProvider
implements WebSessionProvider {
    private final Map<String, Map<String, String>> sessions = new ConcurrentHashMap<String, Map<String, String>>();

    @Override
    public String find(String sessionId, String name) {
        Map<String, String> session = this.sessions.get(sessionId);
        if (session != null) {
            return session.get(name);
        }
        return null;
    }

    @Override
    public void save(String sessionId, String name, String value) {
        Map<String, String> session = this.sessions.get(sessionId);
        if (session == null) {
            session = new ConcurrentHashMap<String, String>();
            this.sessions.put(sessionId, session);
        }
        if (value == null) {
            session.remove(name);
        } else {
            session.put(name, value);
        }
    }
}

