/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.impl.convert;

import de.odysseus.el.misc.TypeConverter;
import java.lang.reflect.Array;
import org.bridje.el.ElAdvanceConverter;
import org.bridje.http.HttpReqParam;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.ioc.Priority;

@Component
@Priority(value=3000)
class HttpReqParamConverter
implements ElAdvanceConverter {
    @Inject
    private TypeConverter conv;

    HttpReqParamConverter() {
    }

    public <F, T> boolean canConvert(Class<F> from, Class<T> to) {
        return HttpReqParam.class.isAssignableFrom(from);
    }

    public <T> T convert(Object value, Class<T> type) {
        HttpReqParam param = (HttpReqParam)value;
        Class<Object> resClass = type;
        if (resClass.isArray()) {
            resClass = type.getComponentType();
            String[] values = param.getAllValues();
            Object[] result = (Object[])Array.newInstance(resClass, values.length);
            for (int i = 0; i < values.length; ++i) {
                result[i] = this.doConvert(values[i], resClass);
            }
            return (T)result;
        }
        return (T)this.doConvert(param.getValue(), resClass);
    }

    private Object doConvert(String value, Class<?> resClass) {
        if (Boolean.class.isAssignableFrom(resClass) || Boolean.TYPE.isAssignableFrom(resClass)) {
            return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
        }
        return this.conv.convert((Object)value, resClass);
    }
}

