/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.impl;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridje.el.ElService;
import org.bridje.ioc.Ioc;

class WebMethodData {
    private static final Logger LOG = Logger.getLogger(WebMethodData.class.getName());
    private final String expression;
    private final Class<?> component;
    private final Method method;
    private final String regExp;
    private final Pattern pattern;
    private final ElService elServ;

    public WebMethodData(String expression, Class<?> component, Method method) {
        this.expression = expression;
        this.component = component;
        this.method = method;
        this.regExp = WebMethodData.toRegExp(expression);
        this.elServ = (ElService)Ioc.context().find(ElService.class);
        this.pattern = Pattern.compile(this.regExp);
    }

    public String getExpression() {
        return this.expression;
    }

    public Class<?> getComponent() {
        return this.component;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public Object[] matches(String path) {
        Parameter[] params = this.method.getParameters();
        Matcher matcher = this.pattern.matcher(path);
        if (matcher.matches()) {
            if (matcher.groupCount() >= 1) {
                Object[] result = new Object[matcher.groupCount()];
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    String value = this.urlDecode(matcher.group(i + 1));
                    result[i] = params[i] != null ? this.doCast(value, params[i].getType()) : value;
                }
                return result;
            }
            return new Object[0];
        }
        return null;
    }

    public static String toRegExp(String path) {
        String result = path;
        result = result.replaceAll("[\\/]", "\\\\/");
        result = result.replaceAll("\\$\\{[a-zA-Z0-9]+\\}", "([^\\\\/]+)");
        result = "^" + result + "$";
        return result;
    }

    private Object doCast(String value, Class<?> type) {
        return this.elServ.convert((Object)value, type);
    }

    private String urlDecode(String group) {
        try {
            return URLDecoder.decode(group, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return group;
        }
    }
}

