/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bridje.http.HttpBridlet;
import org.bridje.http.HttpBridletContext;
import org.bridje.http.HttpBridletResponse;
import org.bridje.http.HttpException;
import org.bridje.ioc.Component;
import org.bridje.ioc.InjectNext;
import org.bridje.ioc.Priority;
import org.bridje.vfs.Path;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VFileInputStream;
import org.bridje.web.WebScope;

@Component
@Priority(value=700)
class RenderFileBridlet
implements HttpBridlet {
    @InjectNext
    private HttpBridlet nextHandler;
    private final Path PUBLIC_PATH = new Path("/web/public");

    RenderFileBridlet() {
    }

    public boolean handle(HttpBridletContext context) throws IOException, HttpException {
        Path path;
        String pathStr;
        VFile file = (VFile)context.get(VFile.class);
        if (file == null && (pathStr = ((WebScope)context.get(WebScope.class)).getPath()) != null && !pathStr.endsWith(".view.xml") && !pathStr.endsWith(".layout.xml") && (path = new Path(pathStr).getCanonicalPath()) != null) {
            path = this.PUBLIC_PATH.join(path);
            file = new VFile(path);
        }
        if (file != null && file.exists() && file.isFile()) {
            HttpBridletResponse resp = context.getResponse();
            try (VFileInputStream is = new VFileInputStream(file);
                 OutputStream os = resp.getOutputStream();){
                resp.setContentType(file.getMimeType());
                this.copy((InputStream)is, os);
                os.flush();
            }
            return true;
        }
        return this.nextHandler != null && this.nextHandler.handle(context);
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[1024];
        int bytesCount = is.read(buffer);
        while (bytesCount > -1) {
            os.write(buffer, 0, bytesCount);
            bytesCount = is.read(buffer);
        }
    }
}

