/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.http.HttpBridlet;
import org.bridje.http.HttpBridletContext;
import org.bridje.http.HttpCookie;
import org.bridje.http.HttpException;
import org.bridje.http.HttpReqParam;
import org.bridje.ioc.Component;
import org.bridje.ioc.InjectNext;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.Priority;
import org.bridje.web.ReqPathRef;
import org.bridje.web.WebCookie;
import org.bridje.web.WebMethod;
import org.bridje.web.WebParameter;
import org.bridje.web.WebScope;
import org.bridje.web.impl.WebMethodData;

@Component
@Priority(value=500)
class ControllerBridlet
implements HttpBridlet {
    private static final Logger LOG = Logger.getLogger(ControllerBridlet.class.getName());
    private List<WebMethodData> methodsData;
    @InjectNext
    private HttpBridlet next;

    ControllerBridlet() {
    }

    public boolean handle(HttpBridletContext context) throws IOException, HttpException {
        Object result;
        IocContext wrsCtx = (IocContext)context.get(IocContext.class);
        if (this.methodsData == null) {
            this.initMethods((IocContext<WebScope>)wrsCtx);
        }
        if ((result = this.invokeMethod((IocContext<WebScope>)wrsCtx, ReqPathRef.findCurrentPath(context))) != null) {
            context.set(result.getClass(), result);
        }
        if (this.next != null) {
            return this.next.handle(context);
        }
        return false;
    }

    private synchronized void initMethods(IocContext<WebScope> wrsCtx) {
        if (this.methodsData == null) {
            this.methodsData = new ArrayList<WebMethodData>();
            wrsCtx.getClassRepository().forEachMethod(WebMethod.class, (method, component, annotation) -> this.methodsData.add(new WebMethodData(annotation.value(), component, method)));
        }
    }

    private Object invokeMethod(IocContext<WebScope> wrsCtx, String path) throws HttpException {
        for (WebMethodData methodData : this.methodsData) {
            Object[] matches = methodData.matches(path);
            if (matches == null) continue;
            Object cmp = wrsCtx.find(methodData.getComponent());
            this.injectParameters(wrsCtx, cmp);
            try {
                return methodData.getMethod().invoke(cmp, matches);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof HttpException) {
                    throw (HttpException)e.getCause();
                }
                throw new HttpException(500, e.getCause().getMessage(), e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HttpException(500, e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private void injectParameters(IocContext<WebScope> wrsCtx, Object cmp) {
        Field[] fields;
        for (Field field : fields = cmp.getClass().getDeclaredFields()) {
            WebParameter param = field.getAnnotation(WebParameter.class);
            if (param != null) {
                this.injectParameter(wrsCtx, cmp, field, param);
                continue;
            }
            WebCookie cookie = field.getAnnotation(WebCookie.class);
            if (cookie == null) continue;
            this.injectCookie(wrsCtx, cmp, field, cookie);
        }
    }

    private void injectParameter(IocContext<WebScope> wrsCtx, Object cmp, Field field, WebParameter param) {
        String name = param.value();
        HttpReqParam paramVal = ((WebScope)wrsCtx.getScope()).getPostParameter(name);
        if (paramVal == null && (paramVal = ((WebScope)wrsCtx.getScope()).getGetParameter(name)) != null) {
            try {
                field.setAccessible(true);
                field.set(cmp, paramVal);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private void injectCookie(IocContext<WebScope> wrsCtx, Object cmp, Field field, WebCookie cookie) {
        String name = cookie.value();
        HttpCookie cookieVal = ((WebScope)wrsCtx.getScope()).getCookie(name);
        if (cookieVal != null) {
            try {
                field.setAccessible(true);
                field.set(cmp, cookieVal.getValue());
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

