/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web.i18n;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.web.i18n.WebI18nProvider;

@Component
public class WebI18nServices {
    private Map<String, ResourceBundle> i18nMap;
    @Inject
    private WebI18nProvider[] webI18nProv;

    @PostConstruct
    private void init() {
        this.initI18nMap();
    }

    private void initI18nMap() {
        this.i18nMap = new HashMap<String, ResourceBundle>();
        for (WebI18nProvider webI18nProvider : this.webI18nProv) {
            Map<String, ResourceBundle> map = webI18nProvider.findResourceBundles();
            this.i18nMap.putAll(map);
        }
        this.i18nMap = Collections.unmodifiableMap(this.i18nMap);
    }

    public Map<String, ResourceBundle> getI18nMap() {
        return this.i18nMap;
    }
}

