/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.web;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.http.HttpBridletContext;
import org.bridje.http.HttpBridletRequest;
import org.bridje.http.HttpBridletResponse;
import org.bridje.http.HttpCookie;
import org.bridje.http.HttpReqParam;
import org.bridje.ioc.Inject;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.Scope;
import org.bridje.web.ReqPathRef;
import org.bridje.web.session.WebSession;

public final class WebScope
implements Scope {
    private static final Logger LOG = Logger.getLogger(WebScope.class.getName());
    private final HttpBridletRequest req;
    private final HttpBridletResponse resp;
    @Inject
    private IocContext<WebScope> iocCtx;
    private final HttpBridletContext srvCtx;
    private WebSession session;
    private Map<String, String> stateMap;

    public WebScope(HttpBridletContext ctx) {
        this.srvCtx = ctx;
        this.req = ctx.getRequest();
        this.resp = ctx.getResponse();
    }

    public IocContext<WebScope> getIocContext() {
        return this.iocCtx;
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public String getHost() {
        return this.req.getHost();
    }

    public String getUserAgent() {
        return this.req.getUserAgent();
    }

    public String getAccept() {
        return this.req.getAccept();
    }

    public String getPath() {
        return ReqPathRef.findCurrentPath(this.srvCtx);
    }

    public String getOrigPath() {
        return this.req.getPath();
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public boolean isGet() {
        return this.req.isGet();
    }

    public boolean isPost() {
        return this.req.isPost();
    }

    public boolean isDelete() {
        return this.req.isDelete();
    }

    public boolean isPut() {
        return this.req.isPut();
    }

    public boolean isPatch() {
        return this.req.isPatch();
    }

    public String getHeader(String header) {
        return this.req.getHeader(header);
    }

    public Map<String, HttpReqParam> getPostParameters() {
        return this.req.getPostParameters();
    }

    public HttpReqParam getPostParameter(String parameter) {
        return this.req.getPostParameter(parameter);
    }

    public String[] getPostParametersNames() {
        return this.req.getPostParametersNames();
    }

    public Map<String, HttpReqParam> getGetParameters() {
        return this.req.getGetParameters();
    }

    public HttpReqParam getGetParameter(String parameter) {
        return this.req.getGetParameter(parameter);
    }

    public String[] getGetParametersNames() {
        return this.req.getGetParametersNames();
    }

    public Map<String, HttpCookie> getCookies() {
        return this.req.getCookies();
    }

    public HttpCookie getCookie(String name) {
        return this.req.getCookie(name);
    }

    public HttpCookie addCookie(String name, String value) {
        return this.resp.addCookie(name, value);
    }

    public String[] getCookiesNames() {
        return this.req.getCookiesNames();
    }

    public void preCreateComponent(Class<Object> clazz) {
    }

    public void preInitComponent(Class<Object> clazz, Object instance) {
    }

    public void postInitComponent(Class<Object> clazz, Object instance) {
    }

    public WebSession getSession() {
        if (this.session == null) {
            this.session = (WebSession)this.srvCtx.get(WebSession.class);
        }
        return this.session;
    }

    public String getStateValue(String name) {
        if (this.stateMap == null) {
            this.initStateMap();
        }
        return this.stateMap.get(name);
    }

    private void initStateMap() {
        try {
            String[] statesArr;
            this.stateMap = new HashMap<String, String>();
            String state = this.getHeader("Bridje-State");
            if (state == null || state.isEmpty()) {
                return;
            }
            for (String pair : statesArr = state.split("&")) {
                String[] pairArr = pair.split("=");
                if (pairArr.length <= 1) continue;
                this.stateMap.put(pairArr[0], URLDecoder.decode(pairArr[1], "UTF-8"));
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

