
package org.bridje.web.session;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/*
 * Copyright 2016 Bridje Framework.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * This annotation can be use with the fields of web components to mark then as
 * web session fields. web session fields will be persisted amoung diferent
 * requests, this is thwy will be loaded and saved to the current web session on
 * each http request, when ever they are requested.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface WebSessionField
{
    /**
     * The name for this web session field. The data for this field will be
     * stored in the web session with this name.
     *
     * @return The name for this web session field.
     */
    String value();
}
