/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.vfs.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.bridje.vfs.GlobExpr;
import org.bridje.vfs.Path;
import org.bridje.vfs.VFile;
import org.bridje.vfs.impl.VfsFolderNode;

abstract class VfsNode {
    private final String name;
    private VfsFolderNode parent;

    public VfsNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VfsFolderNode getParent() {
        return this.parent;
    }

    public void setParent(VfsFolderNode parent) {
        this.parent = parent;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public Path getPath() {
        if (this.name == null) {
            return new Path();
        }
        return this.getParentPath().join(this.name);
    }

    private Path getParentPath() {
        if (this.name == null) {
            return new Path();
        }
        if (this.parent == null) {
            return new Path();
        }
        return this.getParent().getPath();
    }

    protected abstract VFile[] search(GlobExpr var1, Path var2);

    protected abstract boolean isDirectory(Path var1);

    protected abstract boolean isFile(Path var1);

    protected abstract boolean exists(Path var1);

    protected abstract boolean canWrite(Path var1);

    protected abstract boolean canRead(Path var1);

    protected abstract String[] list(Path var1);

    protected abstract InputStream openForRead(Path var1);

    protected abstract OutputStream openForWrite(Path var1);

    protected abstract boolean createNewFile(Path var1);

    protected abstract boolean delete(Path var1);

    protected abstract boolean mkdir(Path var1);
}

