/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.vfs.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bridje.vfs.GlobExpr;
import org.bridje.vfs.Path;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VfsSource;
import org.bridje.vfs.impl.VfsNode;
import org.bridje.vfs.impl.VfsSourceNode;

class VfsSourceNodeProxy
extends VfsNode {
    private final List<VfsSourceNode> nodes = new ArrayList<VfsSourceNode>();

    public VfsSourceNodeProxy(String name) {
        super(name);
    }

    public void add(VfsSource source) {
        VfsSourceNode node = new VfsSourceNode(this.getName(), source);
        node.setParent(this.getParent());
        this.nodes.add(node);
    }

    @Override
    public VFile[] search(GlobExpr globExpr, Path path) {
        if (this.nodes.isEmpty()) {
            return new VFile[0];
        }
        LinkedList files = new LinkedList();
        LinkedList<VfsSourceNode> reverseNodes = new LinkedList<VfsSourceNode>(this.nodes);
        Collections.reverse(reverseNodes);
        reverseNodes.forEach(node -> {
            VFile[] nodeFiles = node.search(globExpr, path);
            if (nodeFiles != null) {
                for (VFile file : nodeFiles) {
                    if (files.contains(file)) continue;
                    files.add(file);
                }
            }
        });
        return files.toArray(new VFile[0]);
    }

    @Override
    public boolean isDirectory(Path path) {
        VfsSourceNode last = this.last();
        return last != null && last.isDirectory(path);
    }

    @Override
    public boolean isFile(Path path) {
        VfsSourceNode last = this.last();
        return last != null && last.isFile(path);
    }

    @Override
    public boolean exists(Path path) {
        if (this.nodes.isEmpty()) {
            return false;
        }
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            if (!this.nodes.get(i).exists(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(Path path) {
        VfsSourceNode last = this.last();
        return last != null && last.canWrite(path);
    }

    @Override
    public boolean canRead(Path path) {
        VfsSourceNode last = this.last();
        return last != null && last.canRead(path);
    }

    @Override
    public String[] list(Path path) {
        if (this.nodes.isEmpty()) {
            return new String[0];
        }
        LinkedList list = new LinkedList();
        LinkedList<VfsSourceNode> reverseNodes = new LinkedList<VfsSourceNode>(this.nodes);
        Collections.reverse(reverseNodes);
        reverseNodes.forEach(node -> {
            String[] nodeList = node.list(path);
            if (nodeList != null) {
                for (String name : nodeList) {
                    if (list.contains(name)) continue;
                    list.add(name);
                }
            }
        });
        return list.toArray(new String[0]);
    }

    @Override
    public InputStream openForRead(Path path) {
        if (this.nodes.isEmpty()) {
            return null;
        }
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            if (!this.nodes.get(i).exists(path)) continue;
            return this.nodes.get(i).openForRead(path);
        }
        return null;
    }

    @Override
    public OutputStream openForWrite(Path path) {
        if (this.nodes.isEmpty()) {
            return null;
        }
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            if (!this.nodes.get(i).exists(path)) continue;
            return this.nodes.get(i).openForWrite(path);
        }
        return null;
    }

    @Override
    public boolean createNewFile(Path path) {
        VfsSourceNode last = this.last();
        return last != null && last.createNewFile(path);
    }

    @Override
    public boolean delete(Path path) {
        VfsSourceNode last = this.last();
        return last != null && last.delete(path);
    }

    @Override
    public boolean mkdir(Path path) {
        VfsSourceNode last = this.last();
        return last != null && last.mkdir(path);
    }

    private VfsSourceNode last() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }
}

