/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.vfs.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.bridje.ioc.Component;
import org.bridje.vfs.CpSource;
import org.bridje.vfs.GlobExpr;
import org.bridje.vfs.Path;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VFileInputStream;
import org.bridje.vfs.VfsService;
import org.bridje.vfs.VfsSource;
import org.bridje.vfs.impl.VfsFolderNode;

@Component
class VfsServiceImpl
implements VfsService {
    private static final Logger LOG = Logger.getLogger(VfsServiceImpl.class.getName());
    private final VfsFolderNode root = new VfsFolderNode(null);
    private final Properties mimeTypes = new Properties();

    @PostConstruct
    public synchronized void init() throws IOException, URISyntaxException {
        VFile[] sources;
        VFile vfsBridje = new VFile("/vfs/bridje");
        vfsBridje.mount(new CpSource("/BRIDJE-INF/vfs"));
        VFile mimeTypes = new VFile(vfsBridje.getPath().join("mime-types.properties"));
        VFile[] vFileArray = null;
        try (VFileInputStream is = new VFileInputStream(mimeTypes);){
            this.mimeTypes.load(is);
        }
        catch (Throwable object) {
            vFileArray = object;
            throw object;
        }
        for (VFile source : sources = vfsBridje.search(new GlobExpr("*-classpath-sources.properties"))) {
            try (VFileInputStream is = new VFileInputStream(source);){
                Properties prop = new Properties();
                prop.load(is);
                Set<Map.Entry<Object, Object>> entrySet = prop.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    try {
                        VFile folder = new VFile((String)entry.getKey());
                        folder.mount(new CpSource((String)entry.getValue()));
                    }
                    catch (IOException | URISyntaxException e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Reading " + source.getName() + ": " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public synchronized void mount(Path path, VfsSource source) throws FileNotFoundException {
        this.root.mount(path, source);
    }

    @Override
    public boolean isDirectory(Path path) {
        return this.root.isDirectory(path);
    }

    @Override
    public boolean isFile(Path path) {
        return this.root.isFile(path);
    }

    @Override
    public boolean exists(Path path) {
        return this.root.exists(path);
    }

    @Override
    public boolean canWrite(Path path) {
        return this.root.canWrite(path);
    }

    @Override
    public boolean canRead(Path path) {
        return this.root.canRead(path);
    }

    @Override
    public String[] list(Path path) {
        return this.root.list(path);
    }

    @Override
    public InputStream openForRead(Path path) {
        return this.root.openForRead(path);
    }

    @Override
    public OutputStream openForWrite(Path path) {
        return this.root.openForWrite(path);
    }

    @Override
    public VFile[] search(GlobExpr globExpr, Path path) {
        return this.root.search(globExpr, path);
    }

    @Override
    public boolean createNewFile(Path path) {
        return this.root.createNewFile(path);
    }

    @Override
    public boolean delete(Path path) {
        return this.root.delete(path);
    }

    @Override
    public boolean mkdir(Path path) {
        return this.root.mkdir(path);
    }

    @Override
    public String getMimeType(String extension) {
        return (String)this.mimeTypes.get(extension);
    }
}

