/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.vfs;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.bridje.ioc.Ioc;
import org.bridje.vfs.GlobExpr;
import org.bridje.vfs.Path;
import org.bridje.vfs.VfsService;
import org.bridje.vfs.VfsSource;

public class VFile {
    private static VfsService VFS;
    private final Path path;

    private static VfsService getVfs() {
        if (VFS == null) {
            VFS = (VfsService)Ioc.context().find(VfsService.class);
        }
        return VFS;
    }

    public VFile(Path path) {
        this.path = path != null ? path.getCanonicalPath() : null;
    }

    public VFile(String path) {
        this(new Path(path));
    }

    public String getName() {
        return this.path.getName();
    }

    public Path getPath() {
        return this.path;
    }

    public VFile getParent() {
        if (this.path.isRoot()) {
            return null;
        }
        return new VFile(this.path.getParent());
    }

    public boolean isDirectory() {
        return VFile.getVfs().isDirectory(this.path);
    }

    public boolean exists() {
        return VFile.getVfs().exists(this.path);
    }

    public boolean createNewFile() {
        return VFile.getVfs().createNewFile(this.path);
    }

    public boolean delete() {
        return VFile.getVfs().delete(this.path);
    }

    public boolean mkdir() {
        return VFile.getVfs().mkdir(this.path);
    }

    public boolean isFile() {
        return VFile.getVfs().isFile(this.path);
    }

    public boolean canWrite() {
        return VFile.getVfs().canWrite(this.path);
    }

    public boolean canRead() {
        return VFile.getVfs().canRead(this.path);
    }

    public void mount(VfsSource source) throws FileNotFoundException {
        VFile.getVfs().mount(this.path, source);
    }

    public String[] list() {
        return VFile.getVfs().list(this.path);
    }

    public VFile[] listFiles() {
        String[] list = VFile.getVfs().list(this.path);
        VFile[] result = new VFile[list.length];
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            result[i] = new VFile(this.path.join(name));
        }
        return result;
    }

    InputStream openForRead() {
        return VFile.getVfs().openForRead(this.path);
    }

    OutputStream openForWrite() {
        return VFile.getVfs().openForWrite(this.path);
    }

    public VFile[] search(GlobExpr globExpr) {
        return VFile.getVfs().search(globExpr, this.path);
    }

    public String getMimeType() {
        String ext = this.path.getExtension();
        if (ext == null || ext.trim().isEmpty()) {
            return null;
        }
        return VFile.getVfs().getMimeType(ext);
    }

    public String toString() {
        return this.path.toString();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VFile other = (VFile)obj;
        return Objects.equals(this.path, other.path);
    }
}

