/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.vfs;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class Path
implements Iterable<Path> {
    private final String[] pathElements;

    public Path() {
        this.pathElements = null;
    }

    public Path(String path) {
        this(Path.createElements(path));
    }

    private Path(String[] pathElements) {
        this.pathElements = pathElements != null && pathElements.length > 0 ? pathElements : null;
    }

    public String[] getPathElements() {
        return this.pathElements;
    }

    public String getFirstElement() {
        if (this.pathElements == null) {
            return null;
        }
        return this.pathElements[0];
    }

    public String getName() {
        if (this.pathElements == null) {
            return "/";
        }
        return this.pathElements[this.pathElements.length - 1];
    }

    public Path getParent() {
        if (this.isLast()) {
            return new Path();
        }
        String[] copyOfRange = Arrays.copyOfRange(this.pathElements, 0, this.pathElements.length - 1);
        return new Path(copyOfRange);
    }

    public Path getNext() {
        if (this.isLast()) {
            return null;
        }
        String[] copyOfRange = Arrays.copyOfRange(this.pathElements, 1, this.pathElements.length);
        return new Path(copyOfRange);
    }

    public boolean hasNext() {
        return !this.isLast();
    }

    public boolean isRoot() {
        return this.pathElements == null || this.pathElements.length == 0;
    }

    public boolean isSelf() {
        if (this.isRoot()) {
            return false;
        }
        return ".".equalsIgnoreCase(this.pathElements[0]);
    }

    public boolean isParent() {
        if (this.isRoot()) {
            return false;
        }
        return "..".equalsIgnoreCase(this.pathElements[0]);
    }

    public boolean isLast() {
        if (this.isRoot()) {
            return true;
        }
        return this.pathElements.length <= 1;
    }

    public Path getCanonicalPath() {
        if (this.isRoot()) {
            return this;
        }
        LinkedList<String> str = new LinkedList<String>();
        for (String pe : this.pathElements) {
            if (pe.equalsIgnoreCase("..")) {
                if (str.isEmpty()) {
                    return null;
                }
                str.remove(str.size() - 1);
                continue;
            }
            if (pe.equalsIgnoreCase(".")) continue;
            str.add(pe);
        }
        if (str.isEmpty()) {
            return null;
        }
        String[] els = new String[str.size()];
        return new Path(str.toArray(els));
    }

    public String toString() {
        if (this.isRoot()) {
            return "/";
        }
        return this.toString("/");
    }

    public String toString(String pathSep) {
        if (this.isRoot()) {
            return pathSep;
        }
        return String.join((CharSequence)pathSep, this.pathElements);
    }

    public Path join(Path path) {
        if (path.isRoot()) {
            return new Path(this.pathElements);
        }
        if (this.isRoot()) {
            return new Path(path.pathElements);
        }
        String[] newElements = new String[this.pathElements.length + path.pathElements.length];
        System.arraycopy(this.pathElements, 0, newElements, 0, this.pathElements.length);
        System.arraycopy(path.pathElements, 0, newElements, this.pathElements.length, path.pathElements.length);
        return new Path(newElements);
    }

    public Path join(String path) {
        if (this.isRoot()) {
            return new Path(path);
        }
        return this.join(new Path(path));
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return !Path.this.isRoot() && this.currentIndex < Path.this.pathElements.length;
            }

            @Override
            public Path next() {
                if (Path.this.isRoot()) {
                    return null;
                }
                String[] copyOfRange = Arrays.copyOfRange(Path.this.pathElements, 0, this.currentIndex + 1);
                ++this.currentIndex;
                return new Path(copyOfRange);
            }
        };
    }

    public String getExtension() {
        if (this.isRoot()) {
            return null;
        }
        String[] split = this.getName().split("[\\.]");
        if (split.length > 1) {
            return split[split.length - 1];
        }
        return null;
    }

    private static String[] createElements(String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("The specified path is not valid.");
        }
        if (path.equals("/")) {
            return null;
        }
        String normPath = Path.normalize(path);
        String[] arr = normPath.split("/");
        return arr;
    }

    private static String normalize(String path) {
        String normPath = path;
        String toReplace = "\\";
        while (normPath.contains(toReplace)) {
            normPath = normPath.replace(toReplace, "/");
        }
        if (path.startsWith("/")) {
            normPath = normPath.substring(1);
        }
        if (normPath.endsWith("/")) {
            normPath = normPath.substring(0, normPath.length() - 1);
        }
        return normPath.trim();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return this.toString().equals(other.toString());
    }

    public boolean startsWith(Path path) {
        if (path.pathElements == null || path.pathElements.length == 0) {
            return true;
        }
        if (this.pathElements == null || this.pathElements.length == 0) {
            return true;
        }
        if (path.pathElements.length > this.pathElements.length) {
            return false;
        }
        for (int i = 0; i < path.pathElements.length; ++i) {
            if (this.pathElements[i].equals(path.pathElements[i])) continue;
            return false;
        }
        return true;
    }

    public Path leftTrim(Path path) {
        if (path == null || path.pathElements == null || path.pathElements.length == 0) {
            return new Path(this.pathElements);
        }
        if (this.pathElements == null || this.pathElements.length == 0) {
            return new Path();
        }
        if (path.pathElements.length > this.pathElements.length) {
            return null;
        }
        for (int i = 0; i < path.pathElements.length; ++i) {
            if (this.pathElements[i].equals(path.pathElements[i])) continue;
            return null;
        }
        return new Path(Arrays.copyOfRange(this.pathElements, path.pathElements.length, this.pathElements.length));
    }
}

