/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.vfs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridje.vfs.Path;

public class GlobExpr {
    private final String glob;
    private final Pattern pattern;

    public GlobExpr(String glob) {
        this.glob = glob;
        String regex = this.globToRegex();
        this.pattern = Pattern.compile(regex);
    }

    public String getValue() {
        return this.glob;
    }

    public String toString() {
        return this.glob;
    }

    public boolean globMatches(Path path) {
        if (path.isRoot()) {
            return false;
        }
        String normPath = path.toString();
        Matcher matcher = this.pattern.matcher(normPath);
        return matcher.matches();
    }

    public Path globRemaining(Path path) {
        int end;
        if (path.isRoot()) {
            return null;
        }
        String normPath = path.toString();
        Matcher matcher = this.pattern.matcher(normPath);
        if (matcher.find() && (end = matcher.end()) > 0 && end < normPath.length()) {
            return new Path(normPath.substring(end));
        }
        return path;
    }

    private String globToRegex() {
        String regex = GlobExpr.normalize(this.glob);
        regex = this.replaceGlobBoundaries(regex, "[", "]", true);
        regex = regex.replaceAll("\\.", "\\\\.");
        regex = regex.replaceAll("\\*\\*", "(\\\\s|\\\\w|-|\\\\.|/)+");
        regex = regex.replaceAll("\\*", "(\\\\s|\\\\w|-|\\\\.)*");
        regex = regex.replaceAll("\\?", "(\\\\s|\\\\w|-|\\\\.)");
        regex = this.replaceGlobBoundaries(regex, "{", "}", false);
        regex = regex.replaceAll("/", "\\\\/");
        regex = regex.replaceAll("ASTERISK", "\\\\*");
        regex = regex.replaceAll("QUESTION", "\\\\?");
        return regex;
    }

    private static String normalize(String path) {
        String normPath = path;
        String toReplace = "\\";
        while (normPath.contains(toReplace)) {
            normPath = normPath.replace(toReplace, "/");
        }
        if (path.startsWith("/")) {
            normPath = normPath.substring(1);
        }
        if (normPath.endsWith("/")) {
            normPath = normPath.substring(0, normPath.length() - 1);
        }
        return normPath.trim();
    }

    private String replaceGlobBoundaries(String glob, String open, String close, boolean escape) {
        String regex = glob;
        String newOpen = "(";
        String newClose = ")";
        int index = regex.indexOf(open);
        while (index >= 0) {
            int endIndex = regex.indexOf(close, index);
            if (endIndex < 0) {
                return glob;
            }
            String[] globs = regex.substring(index + 1, endIndex).split(",");
            String postRegex = regex.substring(endIndex + 1);
            regex = regex.substring(0, index) + newOpen;
            for (int i = 0; i < globs.length; ++i) {
                if (i > 0) {
                    regex = regex + "|";
                }
                String globChild = globs[i].trim();
                if (escape) {
                    globChild = globChild.replaceAll("\\*", "ASTERISK");
                    globChild = globChild.replaceAll("\\?", "QUESTION");
                }
                if (globChild.contains("-") && !globChild.contains("|-|")) {
                    globChild = "[" + globChild + "]";
                }
                regex = regex + globChild;
            }
            int nextIndex = regex.length();
            regex = regex + newClose + postRegex;
            index = regex.indexOf(open, nextIndex);
        }
        return regex;
    }
}

