/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.vfs.GlobExpr;
import org.bridje.vfs.Path;
import org.bridje.vfs.VfsSource;

public class CpSource
implements VfsSource {
    private static final Logger LOG = Logger.getLogger(CpSource.class.getName());
    private final String resource;
    private final ClassLoader clsLoader;
    private Map<String, CpSource> childs;

    public CpSource(String resource) throws IOException, URISyntaxException {
        this(resource, CpSource.class.getClassLoader());
    }

    public CpSource(String resource, ClassLoader classLoader) throws IOException, URISyntaxException {
        this.clsLoader = classLoader;
        this.resource = new Path(resource).toString();
        List<String> resourceListing = this.getResourceListing(this.getClass(), this.resource + "/");
        if (resourceListing != null && !resourceListing.isEmpty()) {
            this.childs = new HashMap<String, CpSource>();
            for (String childName : resourceListing) {
                this.childs.put(childName, new CpSource(new Path(resource).join(childName).toString(), this.clsLoader));
            }
        }
    }

    @Override
    public boolean isDirectory(Path path) {
        if (path == null || path.isRoot()) {
            return this.childs != null;
        }
        CpSource cp = this.childs.get(path.getFirstElement());
        return cp != null && cp.isDirectory(path.getNext());
    }

    @Override
    public boolean isFile(Path path) {
        if (path == null || path.isRoot()) {
            return this.childs == null;
        }
        CpSource cp = this.childs.get(path.getFirstElement());
        return cp != null && cp.isFile(path.getNext());
    }

    @Override
    public boolean exists(Path path) {
        if (path == null) {
            return true;
        }
        if (this.childs == null) {
            return false;
        }
        CpSource cp = this.childs.get(path.getFirstElement());
        return cp != null && cp.exists(path.getNext());
    }

    @Override
    public boolean canWrite(Path path) {
        return false;
    }

    @Override
    public boolean canRead(Path path) {
        return this.isFile(path);
    }

    @Override
    public String[] list(Path path) {
        if (this.childs == null) {
            return null;
        }
        if (path == null) {
            String[] arr = new String[this.childs.size()];
            return this.childs.keySet().toArray(arr);
        }
        CpSource cp = this.childs.get(path.getFirstElement());
        if (cp == null) {
            return null;
        }
        return cp.list(path.getNext());
    }

    @Override
    public InputStream openForRead(Path path) {
        if (path == null) {
            if (this.childs == null) {
                InputStream is = this.clsLoader.getResourceAsStream(this.resource);
                if (is == null) {
                    LOG.log(Level.SEVERE, String.format("Cannot open the resource %s", this.resource));
                }
                return is;
            }
            return null;
        }
        CpSource cp = this.childs.get(path.getFirstElement());
        if (cp == null) {
            return null;
        }
        return cp.openForRead(path.getNext());
    }

    @Override
    public OutputStream openForWrite(Path path) {
        return null;
    }

    private List<String> getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        String currentPath = path;
        if (currentPath.startsWith("/")) {
            currentPath = currentPath.substring(1);
        }
        Enumeration<URL> resources = this.clsLoader.getResources(currentPath);
        HashSet<String> result = new HashSet<String>();
        while (resources.hasMoreElements()) {
            URL dirURL = resources.nextElement();
            if (dirURL != null && dirURL.getProtocol().equals("file")) {
                String[] list = new File(dirURL.toURI()).list();
                if (list == null) {
                    return null;
                }
                result.addAll(Arrays.asList(list));
            }
            if (dirURL == null) {
                String me = clazz.getName().replace(".", "/").concat(".class");
                dirURL = this.clsLoader.getResource(me);
            }
            if (dirURL == null || !dirURL.getProtocol().equals("jar")) continue;
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> currentProjectResource = new HashSet<String>();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName().trim();
                if (!name.startsWith(currentPath)) continue;
                String entry = name.trim().substring(currentPath.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                if (entry.isEmpty()) continue;
                currentProjectResource.add(entry);
            }
            result.addAll(currentProjectResource);
        }
        if (result.isEmpty()) {
            return null;
        }
        LinkedList<String> res = new LinkedList<String>();
        res.addAll(result);
        return res;
    }

    @Override
    public List<Path> search(GlobExpr globExpr, Path path) {
        CpSource resource = this.findResource(path);
        if (resource.isDirectory(null)) {
            ArrayList<Path> files = new ArrayList<Path>();
            resource.search(globExpr, path, files);
            return files;
        }
        return null;
    }

    public CpSource findResource(Path path) {
        if (path == null || path.isRoot()) {
            return this;
        }
        CpSource child = this.childs.get(path.getFirstElement());
        if (child == null) {
            return null;
        }
        return child.findResource(path.getNext());
    }

    public void search(GlobExpr globExpr, Path path, List<Path> files) {
        for (Map.Entry<String, CpSource> entry : this.childs.entrySet()) {
            Path fullPath;
            if (entry.getValue().isDirectory(null)) {
                entry.getValue().search(globExpr, path.join(entry.getKey()), files);
                continue;
            }
            if (!entry.getValue().isFile(null) || !globExpr.globMatches(fullPath = path.join(entry.getKey()))) continue;
            files.add(fullPath);
        }
    }

    @Override
    public boolean createNewFile(Path path) {
        return false;
    }

    @Override
    public boolean mkdir(Path path) {
        return false;
    }

    @Override
    public boolean delete(Path path) {
        return false;
    }
}

