/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.sql.Column;
import org.bridje.sql.ForeignKey;
import org.bridje.sql.Index;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.Schema;
import org.bridje.sql.Table;
import org.bridje.sql.impl.SQLStatementImpl;

class SchemaFixer {
    private static final Logger LOG = Logger.getLogger(SchemaFixer.class.getName());
    private final Connection connection;
    private final Schema schema;
    private final SQLDialect dialect;

    public SchemaFixer(Connection connection, SQLDialect dialect, Schema schema) {
        this.dialect = dialect;
        this.connection = connection;
        this.schema = schema;
    }

    public void doFix() throws SQLException {
        this.fixTables(this.connection, this.schema.getTables());
        this.fixForeignKeys(this.connection, this.schema.getForeignKeys());
        this.fixIndexes(this.connection, this.schema.getIndexes());
    }

    private void fixTables(Connection connection, Table[] tables) throws SQLException {
        for (Table table : tables) {
            this.fixTable(connection, table);
        }
        for (Table table : tables) {
            this.fixForeignKeys(connection, table);
        }
    }

    private void fixIndexes(Connection connection, Index[] indexes) throws SQLException {
        for (Index index : indexes) {
            this.fixIndex(connection, index);
        }
    }

    private void fixForeignKeys(Connection connection, ForeignKey[] foreignKeys) throws SQLException {
        for (ForeignKey fk : foreignKeys) {
            this.fixForeignKey(connection, fk);
        }
    }

    private void fixTable(Connection connection, Table table) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        if (this.tableExists(metaData, table)) {
            this.fixColumns(connection, table);
        } else {
            this.createTable(connection, table);
        }
        this.logMissingColumns(connection, table);
        this.fixIndexes(connection, table.getIndexes());
    }

    private void fixForeignKeys(Connection connection, Table table) throws SQLException {
        this.fixForeignKeys(connection, table.getForeignKeys());
    }

    private boolean tableExists(DatabaseMetaData metadata, Table table) throws SQLException {
        try (ResultSet resultSet = metadata.getTables(null, null, table.getName(), null);){
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean columnExists(DatabaseMetaData metadata, Column<?, ?> column) throws SQLException {
        try (ResultSet resultSet = metadata.getColumns(null, null, column.getTable().getName(), column.getName());){
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private Boolean isNullable(DatabaseMetaData metadata, Column<?, ?> column) throws SQLException {
        try (ResultSet resultSet = metadata.getColumns(null, null, column.getTable().getName(), column.getName());){
            String str;
            if (resultSet.next() && (str = resultSet.getString("IS_NULLABLE")) != null && !str.trim().isEmpty()) {
                Boolean bl = "YES".equalsIgnoreCase(resultSet.getString("IS_NULLABLE"));
                return bl;
            }
        }
        return null;
    }

    private void fixColumns(Connection connection, Table table) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        for (Column<?, ?> column : table.getColumns()) {
            if (!this.columnExists(metadata, column)) {
                try {
                    ArrayList<Object> params = new ArrayList<Object>();
                    String sql = this.dialect.addColumn(column, params);
                    SQLStatementImpl sqlStmt = new SQLStatementImpl(null, sql, params.toArray(), false);
                    this.executeStmt(connection, sqlStmt);
                }
                catch (SQLException e) {
                    LOG.log(Level.SEVERE, String.format("Could not create column %s on table %s.", column.getName(), table.getName()), e);
                }
                continue;
            }
            Boolean isNullable = this.isNullable(metadata, column);
            if (isNullable == null || isNullable.booleanValue() == column.isAllowNull()) continue;
            try {
                String[] sqls;
                ArrayList<Object> params = new ArrayList<Object>();
                for (String sql : sqls = this.dialect.changeColumn(column.getName(), column, params)) {
                    SQLStatementImpl sqlStmt = new SQLStatementImpl(null, sql, params.toArray(), false);
                    this.executeStmt(connection, sqlStmt);
                }
            }
            catch (SQLException e) {
                LOG.log(Level.SEVERE, String.format("Could not change column %s on table %s.", column.getName(), table.getName()), e);
            }
        }
    }

    private void createTable(Connection connection, Table table) throws SQLException {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            String sql = this.dialect.createTable(table, params);
            SQLStatementImpl sqlStmt = new SQLStatementImpl(null, sql, params.toArray(), false);
            this.executeStmt(connection, sqlStmt);
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, String.format("Could not create table %s.", table.getName()), e);
        }
    }

    private void fixIndex(Connection connection, Index index) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        if (!this.indexExists(metadata, index)) {
            try {
                ArrayList<Object> params = new ArrayList<Object>();
                String sql = this.dialect.createIndex(index, params);
                SQLStatementImpl sqlStmt = new SQLStatementImpl(null, sql, new Object[0], false);
                this.executeStmt(connection, sqlStmt);
            }
            catch (SQLException e) {
                LOG.log(Level.SEVERE, String.format("Could not create index %s on table %s.", index.getName(), index.getTable().getName()), e);
            }
        }
    }

    private boolean indexExists(DatabaseMetaData metadata, Index index) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column<?, ?> column : index.getColumns()) {
            columnNames.add(column.getName());
        }
        HashMap<String, ArrayList<String>> idxMap = new HashMap<String, ArrayList<String>>();
        try (ResultSet resultSet = metadata.getIndexInfo(null, null, index.getTable().getName(), false, true);){
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                String colName = resultSet.getString("COLUMN_NAME");
                ArrayList<String> lst = (ArrayList<String>)idxMap.get(indexName);
                if (lst == null) {
                    lst = new ArrayList<String>();
                    idxMap.put(indexName, lst);
                }
                lst.add(colName);
            }
        }
        return idxMap.values().stream().filter(v -> Arrays.equals(v.toArray(), columnNames.toArray())).count() >= 1L;
    }

    private void fixForeignKey(Connection connection, ForeignKey fk) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        if (!this.foreignKeyExists(metadata, fk)) {
            try {
                ArrayList<Object> params = new ArrayList<Object>();
                String sql = this.dialect.createForeignKey(fk, params);
                SQLStatementImpl sqlStmt = new SQLStatementImpl(null, sql, new Object[0], false);
                this.executeStmt(connection, sqlStmt);
            }
            catch (SQLException e) {
                LOG.log(Level.SEVERE, String.format("Could not create foreign key %s on table %s.", fk.getName(), fk.getTable().getName()), e);
            }
        }
    }

    private boolean foreignKeyExists(DatabaseMetaData metadata, ForeignKey fk) throws SQLException {
        try (ResultSet resultSet = metadata.getExportedKeys(null, null, fk.getReferences().getName());){
            while (resultSet.next()) {
                String fkTableName = resultSet.getString("FKTABLE_NAME");
                if (!fk.getTable().getName().equals(fkTableName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private PreparedStatement prepareStatement(Connection cnn, SQLStatement sqlStmt) throws SQLException {
        PreparedStatement stmt = sqlStmt.isWithGeneratedKeys() ? cnn.prepareStatement(sqlStmt.getSQL(), 1) : cnn.prepareStatement(sqlStmt.getSQL());
        Object[] params = sqlStmt.getParameters();
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
        return stmt;
    }

    private int executeStmt(Connection cnn, SQLStatement sqlStmt) throws SQLException {
        LOG.log(Level.INFO, sqlStmt.getSQL());
        try (PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            int n = stmt.executeUpdate();
            return n;
        }
    }

    private void logMissingColumns(Connection connection, Table table) throws SQLException {
        List<String> columns = this.findColumns(connection, table);
        columns.stream().filter(c -> table.getColumn((String)c) == null).forEach(c -> LOG.log(Level.WARNING, String.format("Column %s no longer exists in table %s.", c, table.getName())));
    }

    private List<String> findColumns(Connection connection, Table table) throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        DatabaseMetaData metadata = connection.getMetaData();
        try (ResultSet resultSet = metadata.getColumns(null, null, table.getName(), null);){
            while (resultSet.next()) {
                columns.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return columns;
    }
}

