/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.List;
import org.bridje.sql.BuildSchemaFKsStep;
import org.bridje.sql.BuildSchemaIndexesStep;
import org.bridje.sql.BuildSchemaStep;
import org.bridje.sql.ForeignKey;
import org.bridje.sql.Index;
import org.bridje.sql.Schema;
import org.bridje.sql.Table;
import org.bridje.sql.impl.SchemaImpl;

class SchemaBuilder
implements BuildSchemaStep {
    private final String name;
    private final List<Table> tables;
    private final List<Index> indexes;
    private final List<ForeignKey> foreignKeys;

    public SchemaBuilder(String name) {
        this.name = name;
        this.tables = new ArrayList<Table>();
        this.indexes = new ArrayList<Index>();
        this.foreignKeys = new ArrayList<ForeignKey>();
    }

    @Override
    public BuildSchemaStep table(Table table) {
        this.tables.add(table);
        return this;
    }

    @Override
    public BuildSchemaIndexesStep index(Index index) {
        this.indexes.add(index);
        return this;
    }

    @Override
    public BuildSchemaFKsStep foreignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
        return this;
    }

    @Override
    public Schema build() {
        Table[] tableArr = new Table[this.tables.size()];
        this.tables.toArray(tableArr);
        Index[] indexesArr = new Index[this.indexes.size()];
        this.indexes.toArray(indexesArr);
        ForeignKey[] foreignKeysArr = new ForeignKey[this.foreignKeys.size()];
        this.foreignKeys.toArray(foreignKeysArr);
        return new SchemaImpl(this.name, tableArr, indexesArr, foreignKeysArr);
    }
}

