/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.Column;
import org.bridje.sql.Index;
import org.bridje.sql.Table;

class IndexImpl
implements Index {
    private String name;
    private Table table;
    private final Column<?, ?>[] columns;
    private final boolean unique;

    public IndexImpl(String name, Table table, Column<?, ?>[] columns, boolean unique) {
        this.name = name;
        this.table = table;
        this.columns = columns;
        this.unique = unique;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.createName();
        }
        return this.name;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }

    @Override
    public Column<?, ?>[] getColumns() {
        return this.columns;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    private String createName() {
        if (this.table == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("idx_");
        sb.append(this.table.getName());
        for (Column<?, ?> column : this.columns) {
            sb.append("_");
            sb.append(column.getName());
        }
        return sb.toString();
    }
}

