/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.Column;
import org.bridje.sql.ForeignKey;
import org.bridje.sql.ForeignKeyStrategy;
import org.bridje.sql.Table;

class ForeignKeyImpl
implements ForeignKey {
    private String name;
    private Table table;
    private final Column<?, ?>[] columns;
    private final Table references;
    private final ForeignKeyStrategy onUpdate;
    private final ForeignKeyStrategy onDelete;

    public ForeignKeyImpl(String name, Table table, Column<?, ?>[] columns, Table references, ForeignKeyStrategy onUpdate, ForeignKeyStrategy onDelete) {
        this.name = name;
        this.table = table;
        this.columns = columns;
        this.references = references;
        this.onUpdate = onUpdate;
        this.onDelete = onDelete;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.createName();
        }
        return this.name;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }

    @Override
    public Column<?, ?>[] getColumns() {
        return this.columns;
    }

    @Override
    public Table getReferences() {
        return this.references;
    }

    @Override
    public ForeignKeyStrategy getOnUpdate() {
        return this.onUpdate;
    }

    @Override
    public ForeignKeyStrategy getOnDelete() {
        return this.onDelete;
    }

    private String createName() {
        if (this.table == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("fk_");
        sb.append(this.table.getName());
        for (Column<?, ?> column : this.columns) {
            sb.append("_");
            sb.append(column.getName());
        }
        return sb.toString();
    }
}

