/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.bridje.sql.Query;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLEnvironment;
import org.bridje.sql.SQLResultParser;
import org.bridje.sql.SQLResultSet;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.Schema;
import org.bridje.sql.impl.SQLResultSetImpl;
import org.bridje.sql.impl.SchemaFixer;

abstract class EnvironmentBase
implements SQLEnvironment {
    private static final Logger LOG = Logger.getLogger(EnvironmentBase.class.getName());
    private final SQLDialect dialect;

    public EnvironmentBase(SQLDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public SQLDialect getDialect() {
        return this.dialect;
    }

    protected void fixSchema(Connection connection, Schema schema) throws SQLException {
        new SchemaFixer(connection, this.getDialect(), schema).doFix();
    }

    @Override
    public int update(Query query, Object ... parameters) throws SQLException {
        return this.update(query.toStatement(this.getDialect(), parameters));
    }

    @Override
    public <T> List<T> fetchAll(Query query, SQLResultParser<T> parser, Object ... parameters) throws SQLException {
        return this.fetchAll(query.toStatement(this.getDialect(), parameters), parser);
    }

    @Override
    public <T> T fetchOne(Query query, SQLResultParser<T> parser, Object ... parameters) throws SQLException {
        return this.fetchOne(query.toStatement(this.getDialect(), parameters), parser);
    }

    protected int update(Connection cnn, SQLStatement sqlStmt) throws SQLException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, sqlStmt.getSQL());
        }
        try (PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            int n = stmt.executeUpdate();
            return n;
        }
    }

    protected <T> List<T> fetchAll(DataSource ds, SQLStatement sqlStmt, SQLResultParser<T> parser) throws SQLException {
        SQLResultSetImpl rs;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, sqlStmt.getSQL());
        }
        try (Connection cnn = ds.getConnection();
             PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            if (sqlStmt.isWithGeneratedKeys()) {
                stmt.executeUpdate();
                rs = new SQLResultSetImpl(stmt.getGeneratedKeys(), sqlStmt.getResultFields());
            } else {
                rs = new SQLResultSetImpl(stmt.executeQuery(), sqlStmt.getResultFields());
            }
        }
        return this.fetchAll(rs, parser);
    }

    protected <T> T fetchOne(DataSource ds, SQLStatement sqlStmt, SQLResultParser<T> parser) throws SQLException {
        SQLResultSetImpl rs;
        LOG.log(Level.FINE, sqlStmt.getSQL());
        try (Connection cnn = ds.getConnection();
             PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            if (sqlStmt.isWithGeneratedKeys()) {
                stmt.executeUpdate();
                rs = new SQLResultSetImpl(stmt.getGeneratedKeys(), sqlStmt.getResultFields());
            } else {
                rs = new SQLResultSetImpl(stmt.executeQuery(), sqlStmt.getResultFields());
            }
        }
        return this.fetchOne(rs, parser);
    }

    /*
     * Exception decompiling
     */
    protected int update(DataSource ds, SQLStatement sqlStmt) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected <T> List<T> fetchAll(Connection cnn, SQLStatement sqlStmt, SQLResultParser<T> parser) throws SQLException {
        SQLResultSetImpl rs;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, sqlStmt.getSQL());
        }
        try (PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            if (sqlStmt.isWithGeneratedKeys()) {
                stmt.executeUpdate();
                rs = new SQLResultSetImpl(stmt.getGeneratedKeys(), sqlStmt.getResultFields());
            } else {
                rs = new SQLResultSetImpl(stmt.executeQuery(), sqlStmt.getResultFields());
            }
        }
        return this.fetchAll(rs, parser);
    }

    protected <T> T fetchOne(Connection cnn, SQLStatement sqlStmt, SQLResultParser<T> parser) throws SQLException {
        SQLResultSetImpl rs;
        LOG.log(Level.FINE, sqlStmt.getSQL());
        try (PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            if (sqlStmt.isWithGeneratedKeys()) {
                stmt.executeUpdate();
                rs = new SQLResultSetImpl(stmt.getGeneratedKeys(), sqlStmt.getResultFields());
            } else {
                rs = new SQLResultSetImpl(stmt.executeQuery(), sqlStmt.getResultFields());
            }
        }
        return this.fetchOne(rs, parser);
    }

    protected PreparedStatement prepareStatement(Connection cnn, SQLStatement sqlStmt) throws SQLException {
        PreparedStatement stmt = sqlStmt.isWithGeneratedKeys() ? cnn.prepareStatement(sqlStmt.getSQL(), 1) : cnn.prepareStatement(sqlStmt.getSQL());
        Object[] params = sqlStmt.getParameters();
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
        return stmt;
    }

    private <T> T fetchOne(SQLResultSet rs, SQLResultParser<T> parser) throws SQLException {
        if (rs.next()) {
            return parser.parse(rs);
        }
        return null;
    }

    private <T> List<T> fetchAll(SQLResultSet rs, SQLResultParser<T> parser) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            result.add(parser.parse(rs));
        }
        return result;
    }
}

