/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bridje.sql.Column;
import org.bridje.sql.ForeignKey;
import org.bridje.sql.Index;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.Schema;
import org.bridje.sql.Table;
import org.bridje.sql.impl.ColumnImpl;
import org.bridje.sql.impl.ForeignKeyImpl;
import org.bridje.sql.impl.IndexImpl;

class TableImpl
implements Table {
    private final String name;
    private Schema schema;
    private final Column<?, ?>[] keys;
    private final Column<?, ?>[] aiColumns;
    private final Column<?, ?>[] columns;
    private final ForeignKey[] foreignKeys;
    private final Index[] indexes;
    private final Map<String, Column<?, ?>> columnsMap;

    public TableImpl(String name, Column<?, ?>[] columns, Index[] indexes, ForeignKey[] foreignKeys) {
        this.name = name;
        this.columnsMap = new HashMap();
        ArrayList keysList = new ArrayList();
        ArrayList aiColumnsList = new ArrayList();
        this.columns = columns;
        for (Column<?, ?> column : columns) {
            ((ColumnImpl)column).setTable(this);
            if (column.isKey()) {
                keysList.add(column);
            }
            if (column.isAutoIncrement()) {
                aiColumnsList.add(column);
            }
            this.columnsMap.put(column.getName(), column);
        }
        this.keys = new Column[keysList.size()];
        keysList.toArray(this.keys);
        this.aiColumns = new Column[aiColumnsList.size()];
        keysList.toArray(this.aiColumns);
        this.indexes = indexes;
        for (Index index : indexes) {
            ((IndexImpl)index).setTable(this);
        }
        this.foreignKeys = foreignKeys;
        for (ForeignKey fk : foreignKeys) {
            ((ForeignKeyImpl)fk).setTable(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Column<?, ?>[] getPrimaryKey() {
        return this.keys;
    }

    @Override
    public Column<?, ?>[] getAutoIncrement() {
        return this.aiColumns;
    }

    @Override
    public Column<?, ?>[] getColumns() {
        return this.columns;
    }

    @Override
    public Column<?, ?> getColumn(String name) {
        return this.columnsMap.get(name);
    }

    @Override
    public void writeSQL(SQLBuilder builder) {
        builder.appendObjectName(this.name);
    }

    @Override
    public Index[] getIndexes() {
        return this.indexes;
    }

    @Override
    public ForeignKey[] getForeignKeys() {
        return this.foreignKeys;
    }
}

