/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.List;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.Expression;
import org.bridje.sql.FinalStep;
import org.bridje.sql.FromStep;
import org.bridje.sql.GroupByStep;
import org.bridje.sql.Limit;
import org.bridje.sql.OrderByStep;
import org.bridje.sql.OrderExpr;
import org.bridje.sql.Query;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.SQLWritable;
import org.bridje.sql.SelectExpr;
import org.bridje.sql.SelectLimitStep;
import org.bridje.sql.SelectStep;
import org.bridje.sql.SelectWhereStep;
import org.bridje.sql.TableExpr;
import org.bridje.sql.impl.BuilderBase;
import org.bridje.sql.impl.Join;
import org.bridje.sql.impl.JoinType;
import org.bridje.sql.impl.QueryAsTable;
import org.bridje.sql.impl.SQLBuilderImpl;
import org.bridje.sql.impl.SQLStatementImpl;

class SelectBuilder
extends BuilderBase
implements SelectStep,
FromStep,
SelectWhereStep,
OrderByStep,
GroupByStep,
SelectLimitStep,
SelectExpr,
Query {
    private final Expression<?, ?>[] select;
    private TableExpr from;
    private List<Join> joins;
    private BooleanExpr<?, ?> where;
    private OrderExpr[] groupBys;
    private OrderExpr[] orderBys;
    private BooleanExpr<?, ?> having;
    private Limit limit;

    public SelectBuilder(Expression<?, ?>[] select) {
        this.select = select;
    }

    public Expression<?, ?>[] getSelect() {
        return this.select;
    }

    @Override
    public FromStep from(TableExpr table) {
        this.from = table;
        return this;
    }

    @Override
    public FromStep innerJoin(TableExpr table, BooleanExpr<?, ?> on) {
        if (this.joins == null) {
            this.joins = new ArrayList<Join>();
        }
        this.joins.add(new Join(table, JoinType.INNER, on));
        return this;
    }

    @Override
    public FromStep leftJoin(TableExpr table, BooleanExpr<?, ?> on) {
        this.joins.add(new Join(table, JoinType.LEFT, on));
        return this;
    }

    @Override
    public FromStep rightJoin(TableExpr table, BooleanExpr<?, ?> on) {
        this.joins.add(new Join(table, JoinType.RIGHT, on));
        return this;
    }

    @Override
    public SelectWhereStep where(BooleanExpr<?, ?> condition) {
        this.where = condition;
        return this;
    }

    @Override
    public GroupByStep groupBy(OrderExpr ... groupBys) {
        this.groupBys = groupBys;
        return this;
    }

    @Override
    public OrderByStep orderBy(OrderExpr ... orderBys) {
        this.orderBys = orderBys;
        return this;
    }

    @Override
    public SelectLimitStep having(BooleanExpr<?, ?> condition) {
        this.having = condition;
        return this;
    }

    @Override
    public SelectExpr asTable(String alias) {
        return new QueryAsTable(this, alias);
    }

    @Override
    public FinalStep limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public Query toQuery() {
        return this;
    }

    @Override
    public Expression<?, ?>[] getResultFields() {
        return this.select;
    }

    @Override
    public SQLStatement toStatement(SQLDialect dialect, Object ... parameters) {
        SQLBuilderImpl builder = new SQLBuilderImpl(dialect);
        this.writeSQL(builder);
        String sql = ((Object)builder).toString();
        return new SQLStatementImpl(this.select, sql, this.createParams(builder, parameters), false);
    }

    @Override
    public void writeSQL(SQLBuilder builder) {
        builder.append("SELECT ");
        builder.appendAll(this.select, ", ");
        if (this.from != null) {
            builder.append(" FROM ");
            builder.append(this.from);
        }
        if (this.joins != null) {
            builder.append(' ');
            SQLWritable[] joinArr = new Join[this.joins.size()];
            this.joins.toArray(joinArr);
            builder.appendAll(joinArr, " ");
        }
        if (this.where != null) {
            builder.append(" WHERE ");
            builder.append(this.where);
        }
        if (this.groupBys != null) {
            builder.append(" GROUP BY ");
            builder.appendAll(this.groupBys, ", ");
        }
        if (this.orderBys != null) {
            builder.append(" ORDER BY ");
            builder.appendAll(this.orderBys, ", ");
        }
        if (this.having != null) {
            builder.append(" HAVING ");
            builder.append(this.having);
        }
        if (this.limit != null) {
            builder.append(this.limit);
        }
    }

    @Override
    public boolean isWithGeneratedKeys() {
        return false;
    }
}

